package cn.com.duiba.tuia.activity.center.api.remoteservice.hbase;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.activity.center.api.log.FullLinkLog;

import java.util.Map;

/**
 * 全链路日志 hbase存取服务
 * @author miaohongshuai
*/
@AdvancedFeignClient
public interface RemoteFullLinkLogService {

    /**
     * 根据日志对象插入hbase
     * @param rid
     * @param fullLinkLog
     * @return 记录是否插入成功
     */
    boolean insertFullLinkLogParam(String rid, FullLinkLog fullLinkLog);

    /**
     * 通过rid查询FullLinkLog对象 字段和值map
     * @param rid
     * @return 字段和值map
     */
    Map<String, String> queryFullLinkLogByRid(String rid);

    /**
     * 根据日志对象插入hbase,带扩展Map参数
     * @param rid
     * @param fullLinkLog
     * @return
     */
    boolean insertFullLinkLogParamExt(String rid, FullLinkLog fullLinkLog,Map<String,String> extMap);

    /**
     * 根据前端日志插入hbase
     * @param rid
     * @return
     */
    boolean insertFullLinkLogFrontEndExt(String rid,Map<String,String> extMap);
}
