package cn.com.duiba.tuia.activity.center.api.bean.enums;

/**
 * 类型链接
 */
public enum LinkTypeEnum {

    PAY_LINK(1,"支付链接"),
    REALM(2,"域名"),

    ;

    private Integer type;

    private String desc;

    LinkTypeEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static LinkTypeEnum getEnum(Integer type){
        for (LinkTypeEnum entry : LinkTypeEnum.values()) {
            if(entry.getType().equals(type)) {
                return entry;
            }
        }
        return null;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
