package cn.com.duiba.tuia.activity.center.api.constant;

/**
 * ClassName: LimitType <br/>
 * Function: 限制类型enum. <br/>
 * date: 2017年1月17日 下午8:00:34 <br/>
 *
 * @author wubo
 * @version 
 * @since JDK 1.7
 */
public enum LimitType {
    
    FOREVER("forever","永久",0),
    EVERYDAY("everyday","每天",1);
    
    /** code:限制类型(数据库存储).*/
    private String code;

    /** desc:限制类型描述.*/
    private String desc;
    
    /** type:限制类型(前后台交互 ).*/
    private int type;
    
    LimitType(String code, String desc, int type) {
        this.code = code;
        this.desc = desc;
        this.type = type;
    }
    
    /**
     * getCode. <br/>
     * @return
     */
    public String getCode() {
        return code;
    }

    /**
     * getDesc. <br/>
     * @return
     */
    public String getDesc() {
        return desc;
    }
    
    /**
     * getType. <br/>
     * @return
     */
    public int getType(){
        return type;
    }
    
    /**
     * getTypeByCode:(根据code获取type). <br/>
     * @param code
     * @return int
     */
    public static int getTypeByCode(String code){
        for(LimitType temp:LimitType.values()){
            if(code.equalsIgnoreCase(temp.getCode())){
                return temp.getType();
            }
        }
        return -1;
    }
}
