/**
 * Project Name:activity-center-api<br>
 * File Name:LandDto.java<br>
 * Package Name:cn.com.duiba.tuia.activity.center.api.dto<br>
 * Date:2017年3月23日下午7:46:46<br>
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.<br>
 */
package cn.com.duiba.tuia.activity.center.api.dto;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

import cn.com.duiba.tuia.activity.center.api.common.BaseDto;

/**
 * ClassName: LandDto <br/>
 * Function: 落地页Dto. <br/>
 * Reason: 落地页基本信息. <br/>
 * date: 2017年3月23日 下午7:46:46 <br/>
 *
 * @author wubo
 * @version
 * @since JDK 1.7
 */
public class LandDto extends BaseDto {

    private static final long serialVersionUID = 1L;

    private Long              id;

    /** title:落地页标题. */
    private String            title;

    /** html:落地页皮肤. */
    private String            html;

    /** channel:渠道类型. */
    private String            channel;
    
    /** 网页名称. */
    private String            name;

    /** 0：代码添加，1：模板添加. */
    private Integer           landType;

    /** 自动下载：0-非，1-是. */
    private Integer           autoDownload;

    /** 自动下载时间. */
    private Integer           autoDownloadTime;

    /** 安卓下载地址. */
    private String            downloadAndriod;

    /** ios下载地址. */
    private String            downloadIos;

    /** sso系统AE用户id. */
    private Long              ssoAeId;

    /** 自动跳转类型：0:链接,1:弹层 */
    private Integer           autoDownloadType;

    /**
     * 当前用户类型 null表示可以查询所有 落地页
     * 0：来自广告管理平台，1：来自代理商平台 2:来自JF建站平台
     * @see cn.com.duiba.tuia.activity.center.api.constant.LandPageSource
     */
    private Integer           source;
    private String thumbnailUrl;

    /** 下载类型：0:非微信下载，1：微信下载 */
    private Integer           wxJump;

    /**
     * 积木落地页标签，多个用英文逗号隔开
     */
    private String promoteTag;

    /** 是否共享 0:否 1:是 */
    private Boolean isShared;

    /** 共享者 */
    private String shareName;

    /** 推广方式 0:微信 */
    private Integer promotionWay;

    /** 点击微信 0:复制成功弹窗 1:直接唤醒 */
    private Integer clickWechat;

    /** 广告主账户ID */
    private Long accountId;

    private Date gmtCreate;

    private Date gmtModified;

    /**
     * 模版ID
     */
    private Long templateId;

    /**
     * 并不是最新版本代码包的Id
     */
    private List<Long> notLatestVersionPackageIds;

    /**
     * 所有关联的组件Id
     */
    private List<Long> mappingPackageIds;

    /**
     * wxJump.
     *
     * @return the wxJump
     * @since JDK 1.8
     */
    public Integer getWxJump() {
        return wxJump;
    }

    /**
     * wxJump.
     *
     * @param wxJump the wxJump to set
     * @since JDK 1.8
     */
    public void setWxJump(Integer wxJump) {
        this.wxJump = wxJump;
    }

    public String getThumbnailUrl() {
        return thumbnailUrl;
    }

    public void setThumbnailUrl(String thumbnailUrl) {
        this.thumbnailUrl = thumbnailUrl;
    }

    /**
     * autoDownloadType.
     *
     * @return the autoDownloadType
     * @since JDK 1.8
     */
    public Integer getAutoDownloadType() {
        return autoDownloadType;
    }

    /**
     * autoDownloadType.
     *
     * @param autoDownloadType the autoDownloadType to set
     * @since JDK 1.8
     */
    public void setAutoDownloadType(Integer autoDownloadType) {
        this.autoDownloadType = autoDownloadType;
    }

    /**
     * name.
     *
     * @return the name
     * @since JDK 1.8
     */
    public String getName() {
        return name;
    }

    /**
     * name.
     *
     * @param name the name to set
     * @since JDK 1.8
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * landType.
     *
     * @return the landType
     * @since JDK 1.8
     */
    public Integer getLandType() {
        return landType;
    }

    /**
     * landType.
     *
     * @param landType the landType to set
     * @since JDK 1.8
     */
    public void setLandType(Integer landType) {
        this.landType = landType;
    }

    /**
     * autoDownload.
     *
     * @return the autoDownload
     * @since JDK 1.8
     */
    public Integer getAutoDownload() {
        return autoDownload;
    }

    /**
     * autoDownload.
     *
     * @param autoDownload the autoDownload to set
     * @since JDK 1.8
     */
    public void setAutoDownload(Integer autoDownload) {
        this.autoDownload = autoDownload;
    }
    
    /**
     * autoDownloadTime.
     *
     * @return  the autoDownloadTime
     * @since   JDK 1.8
     */
    public Integer getAutoDownloadTime() {
        return autoDownloadTime;
    }

    /**
     * autoDownloadTime.
     *
     * @return the autoDownloadTime
     * @since JDK 1.8
     */
    public Double getAutoDownloadDoubleTime() {
        if (autoDownloadTime == null) {
            return null;
        }
        BigDecimal dividendDouble = new BigDecimal(autoDownloadTime);
        BigDecimal divisorDouble = new BigDecimal(10);
        return dividendDouble.divide(divisorDouble, 1, BigDecimal.ROUND_HALF_UP).doubleValue();
    }
    
    /**
     * autoDownloadTime.
     *
     * @param   autoDownloadTime    the autoDownloadTime to set
     * @since   JDK 1.8
     */
    public void setAutoDownloadTime(Integer autoDownloadTime) {
        this.autoDownloadTime = autoDownloadTime;
    }


    /**
     * autoDownloadTime.
     *
     * @param autoDownloadTime the autoDownloadTime to set
     * @since JDK 1.8
     */
    public void setAutoDownloadDoubleTime(Double autoDownloadTimeDouble) {
        if (autoDownloadTimeDouble == null) {
            this.autoDownloadTime = null;
        }else {
            this.autoDownloadTime = (int) (autoDownloadTimeDouble*10);
        }
    }

    /**
     * downloadAndriod.
     *
     * @return the downloadAndriod
     * @since JDK 1.8
     */
    public String getDownloadAndriod() {
        return downloadAndriod;
    }

    /**
     * downloadAndriod.
     *
     * @param downloadAndriod the downloadAndriod to set
     * @since JDK 1.8
     */
    public void setDownloadAndriod(String downloadAndriod) {
        this.downloadAndriod = downloadAndriod;
    }

    /**
     * downloadIos.
     *
     * @return the downloadIos
     * @since JDK 1.8
     */
    public String getDownloadIos() {
        return downloadIos;
    }

    /**
     * downloadIos.
     *
     * @param downloadIos the downloadIos to set
     * @since JDK 1.8
     */
    public void setDownloadIos(String downloadIos) {
        this.downloadIos = downloadIos;
    }

    /**
     * ssoAeId.
     *
     * @return the ssoAeId
     * @since JDK 1.8
     */
    public Long getSsoAeId() {
        return ssoAeId;
    }

    /**
     * ssoAeId.
     *
     * @param ssoAeId the ssoAeId to set
     * @since JDK 1.8
     */
    public void setSsoAeId(Long ssoAeId) {
        this.ssoAeId = ssoAeId;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getHtml() {
        return html;
    }

    public void setHtml(String html) {
        this.html = html;
    }

    public String getChannel() {
        return channel;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public Integer getSource() {
        return source;
    }

    public void setSource(Integer source) {
        this.source = source;
    }

    public String getPromoteTag() {
        return promoteTag;
    }

    public void setPromoteTag(String promoteTag) {
        this.promoteTag = promoteTag;
    }

    public Boolean getIsShared() {
        return isShared;
    }

    public void setIsShared(Boolean isShared) {
        this.isShared = isShared;
    }

    public String getShareName() {
        return shareName;
    }

    public void setShareName(String shareName) {
        this.shareName = shareName;
    }

    public Integer getPromotionWay() {
        return promotionWay;
    }

    public void setPromotionWay(Integer promotionWay) {
        this.promotionWay = promotionWay;
    }

    public Integer getClickWechat() {
        return clickWechat;
    }

    public void setClickWechat(Integer clickWechat) {
        this.clickWechat = clickWechat;
    }

    public Long getAccountId() {
        return accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public Long getTemplateId() {
        return templateId;
    }

    public void setTemplateId(Long templateId) {
        this.templateId = templateId;
    }

    public List<Long> getNotLatestVersionPackageIds() {
        return notLatestVersionPackageIds;
    }

    public void setNotLatestVersionPackageIds(List<Long> notLatestVersionPackageIds) {
        this.notLatestVersionPackageIds = notLatestVersionPackageIds;
    }

    public List<Long> getMappingPackageIds() {
        return mappingPackageIds;
    }

    public void setMappingPackageIds(List<Long> mappingPackageIds) {
        this.mappingPackageIds = mappingPackageIds;
    }
}
