package cn.com.duiba.tuia.activity.center.api.log;

import cn.com.duiba.tuia.activity.center.api.util.DateUtils;

import java.util.Date;


/**
 * ClassName: TuiaActivityLog <br/>
 * Function: 推啊活动操作日志. <br/>
 * date: 2017年2月23日 下午5:53:22 <br/>
 *
 * @author wubo
 * @version
 * @since JDK 1.7
 */
public class TuiaActivityLog extends Log {

    /**
     * Creates a new instance of TuiaActivityLog.
     *
     */
    public TuiaActivityLog() {
        super();
        put("time", DateUtils.getSecondStr(new Date()));
    }

    /**
     * activityId:(活动id). <br/>
     * 
     * @param activityId
     * @return TuiaActivityLog
     */
    public TuiaActivityLog activityId(long activityId) {
        put("activityId", activityId);
        return this;
    }

    /**
     * title:(活动名称). <br/>
     * 
     * @param title
     * @return TuiaActivityLog
     */
    public TuiaActivityLog title(String title) {
        put("title", title);
        return this;
    }

    /**
     * activityType:(活动类型). <br/>
     * 
     * @param activityType
     * @return TuiaActivityLog
     */
    public TuiaActivityLog activityType(Integer activityType) {
        put("activityType", activityType);
        return this;
    }

    /**
     * limitCount:(参与次数). <br/>
     * 
     * @param limitCount
     * @return TuiaActivityLog
     */
    public TuiaActivityLog limitCount(Integer limitCount) {
        put("limitCount", limitCount);
        return this;
    }

    /**
     * tag:(标签). <br/>
     * 
     * @param tag
     * @return TuiaActivityLog
     */
    public TuiaActivityLog tag(String tag) {
        put("tag", tag);
        return this;
    }

    /**
     * action:(操作动作). <br/>
     * 
     * @param action
     * @return TuiaActivityLog
     */
    public TuiaActivityLog action(String action) {
        put("action", action);
        return this;
    }
}
