package cn.com.duiba.tuia.activity.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.activity.center.api.common.PageDto;
import cn.com.duiba.tuia.activity.center.api.dto.LandTemplateDTO;
import cn.com.duiba.tuia.activity.center.api.dto.LandTemplateFormDTO;
import cn.com.duiba.tuia.activity.center.api.dto.LandTemplateQueryDTO;

import java.util.List;

/**
 * 落地页模板表 RemoteService
 * @author lijicong
 * @since 2021-07-08
 */
@AdvancedFeignClient
public interface RemoteLandTemplateService {

    /**
     * 根据查询落地页模板
     * @param id
     * @return
     */
    LandTemplateDTO queryById(Long id);

    /**
     * 查询落地页模板
     * @param queryDTO
     * @return
     */
    List<LandTemplateDTO> queryList(LandTemplateQueryDTO queryDTO);

    /**
     * 分页查询落地页模板
     * @param queryDTO
     * @return
     */
    PageDto<LandTemplateDTO> queryPage(LandTemplateQueryDTO queryDTO);

    /**
     * 查询落地页模板数量
     * @param queryDTO
     * @return
     */
    long queryCount(LandTemplateQueryDTO queryDTO);

    /**
     * 保持落地页模板
     * @param formDTO
     * @return
     */
    Long save(LandTemplateFormDTO formDTO);

    /**
     * 根据模版ID批量获取落地页模版
     *
     * @param ids
     * @return
     */
    List<LandTemplateDTO> getByTemplateIds(List<Long> ids);
}
