package cn.com.duiba.tuia.activity.center.api.remoteservice.pc;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.activity.center.api.common.PageDto;
import cn.com.duiba.tuia.activity.center.api.dto.pc.JmPackageDTO;
import cn.com.duiba.tuia.activity.center.api.dto.req.PackagePageReq;

import java.util.List;

/**
 * @author Wangpf
 * @date 2023/12/21 10:46
 */
@AdvancedFeignClient
public interface RemotePackageService {

    /**
     * 发布新的代码包
     *
     * @param dto
     */
    boolean createPackage(JmPackageDTO dto);

    /**
     * 更新代码包
     *
     * @param dto
     * @return
     */
    boolean updatePackage(JmPackageDTO dto);

    /**
     * 分页查询代码包
     *
     * @param req
     * @return
     */
    PageDto<JmPackageDTO> pageQuery(PackagePageReq req);


    /**
     * 回滚代码包的版本
     *
     * @param packageId 代码包ID
     * @param versionId 要回滚的代码包版本
     * @return
     */
    boolean rollBack(Long packageId, Long versionId, Integer modifyId, String modifyName) throws BizException;

    /**
     * 批量查询
     *
     * @param packageIds 代码包ID
     * @return
     */
    List<JmPackageDTO> batchGet(List<Long> packageIds);
}
