package cn.com.duiba.tuia.activity.center.api.remoteservice.staticpage;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.activity.center.api.common.PageDto;
import cn.com.duiba.tuia.activity.center.api.dto.TencentActivityAuditDTO;
import cn.com.duiba.tuia.activity.center.api.dto.TencentLandIdMappingDTO;
import cn.com.duiba.tuia.activity.center.api.dto.staticpage.*;

import java.util.List;
import java.util.Map;

@AdvancedFeignClient
public interface RemoteStaticPageVerifyService {

    /**
     * 静态页面送审接口(落地页专用)
     * @param dto
     * @return
     */
    Boolean submitPageVerify(SubmitPageDto dto);

    /**
     * 静态页面送审接口(活动专用)
     * @param verifyId
     * @return
     */
    Boolean submitActivityVerify(Long verifyId);

    /**
     * 静态页面送审结果记录分页条件查询
     * @param query
     * @return
     */
    PageDto<VerifyPageResultDto> selectVerifyResultByPage(VerifyResultPageQuery query);

    /**
     * 静态页面送审结果记录
     * @param query
     * @return
     */
    List<VerifyPageResultDto> selectVerifyResultList(VerifyResultPageQuery query);

    /**
     * 静态页面送审结果记录全量查询
     * @param query
     * @return
     */
    List<VerifyPageResultDto> selectAllVerifyResult(VerifyAllResultQuery query);

    /**
     * 插入送审记录
     * @return
     */
    Boolean addVerifyResult(StaticPageVerifyResultDto dto);

    /**
     * 根据送审id查询送审记录
     * @param verifyId
     * @return
     */
    VerifyPageResultDto selectVerifyResult(Long verifyId);

    /**
     * 更新爱奇艺审核记录
     * @param dto
     * @return
     */
    Boolean updateVerifyResult(UpdatePageVerifyResultDto dto);

    /**
     * 查询所有的原始静态链接与审核id的映射
     * @return
     */
    Map<String,VerifyPageResultDto> selectAllUrlAndResult();


    PageDto<VerifyActivityListDto> searchVerifyActivityList(SearchVerifyActivityListParamDto dto);


    Boolean addActivityStaticData(ActivityStaticDataDto dto);


    Boolean updateActivityStaticData(ActivityStaticDataDto dto);

    /**
     * 根据原始推啊URL查询送审记录(别用这个)
     * @param url
     * @return
     */
    VerifyPageResultDto selectVerifyResultByUrl(String url);

    ActivityStaticDataDto selectActivityStaticDataById(Long activityId);

    void reUploadAllPage();

    void reUpdateAllPage();

    /**
     * 查询腾讯活动送审详情
     * @param verifyId
     * @return
     */
    TencentActivityAuditDTO tencentActivityDetail(Long verifyId);

    /**
     * 通过活动id查询送审详情
     * @param activityId
     * @return
     */
    TencentActivityAuditDTO tencentActivityDetailByActivityId(Long activityId);


    StaticPageVerifyResultDto selectVerifyResultByActivityId(Long activityId);

    TencentActivityAuditDTO insertTencentActivityAuditRecord(TencentActivityAuditDTO tencentActivityAuditDTO);

    List<TencentLandIdMappingDTO> selectByTencentAuditId(Long auditId);

    int updateLandIdMapping(TencentLandIdMappingDTO tencentLandIdMappingDTO);

    int insertLandIdMapping(TencentLandIdMappingDTO tencentLandIdMappingDTO);

    int updateTencentActivityAuditRecord(TencentActivityAuditDTO tencentActivityAuditDTO);

}
