package cn.com.duiba.tuia.activity.center.api.remoteservice.tag;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.activity.center.api.dto.req.tag.ReqJmLayerNewTagDto;
import cn.com.duiba.tuia.activity.center.api.dto.tag.JmLayerNewTagDto;
import cn.com.duiba.tuia.activity.center.api.dto.tag.JmLayerNewTagLevelDto;

import java.util.List;

/**
 * @author Wangpf
 * @version
 * @since JDK 1.8
 * @see
 */
@AdvancedFeignClient
public interface RemoteJmLayerNewTagService {

    /**
     * insertNewTag:(新增). <br/>
     *
     * @author chencheng
     * @param newTagDto 新标签dto
     * @return
     * @since JDK 1.8
     */
    Integer insertNewTag(JmLayerNewTagDto newTagDto);

    /**
     * selectNewTagByTagNum:(根据tagNum查询标签详情). <br/>
     *
     * @author chencheng
     * @param tagNum 标签tagNum
     * @return
     * @since JDK 1.8
     */
    JmLayerNewTagDto selectNewTagByTagNum(String tagNum);

    /**
     * selectAllNewTagByTagNumList:(获取所有标签的层级关系). <br/>
     *
     * @author chencheng
     * @return
     * @since JDK 1.8
     */
    List<JmLayerNewTagLevelDto> selectAllNewTagByTagNumList();

    /**
     * selectNewTagByTagNum:(根据tagNum查询标签详情). <br/>
     *
     * @author chencheng
     * @param tagNums 多个标签tagNum
     * @return
     * @since JDK 1.8
     */
    List<JmLayerNewTagDto> selectNewTagByTagNumList(List<String> tagNums);

    /**
     * selectNewTagList:(批量查询标签详情，参数可为空标示查询全部). <br/>
     *
     * @author chencheng
     * @param req 新标签查询req
     * @return
     * @since JDK 1.8
     */
    List<JmLayerNewTagDto> selectNewTagList(ReqJmLayerNewTagDto req);

    /**
     * selectNewMaxTagNum:(根据父标签id,子标签级别查询最大子级标签编码 ). <br/>
     *
     * @author chencheng
     * @param parentTagNum 父标签tagNum
     * @param tagLevel 子标签级别
     * @return
     * @since JDK 1.8
     */
    String selectNewMaxTagNum(Integer tagLevel, String parentTagNum);

    /**
     * selectDuplicationTagName:(查询父级标签下标签是否重名). <br/>
     *
     * @author chencheng
     * @param tagName 标签名称
     * @param parentTagNum 父标签tagNum
     * @return
     * @since JDK 1.8
     */
    List<JmLayerNewTagDto> selectDuplicationNewTagName(String tagName, String parentTagNum);

    /**
     * batchUpdateNewTag:(批量更新). <br/>
     *
     * @author chencheng
     * @param req 新标签查询req
     * @return
     * @since JDK 1.8
     */
    Integer batchUpdateNewTag(List<JmLayerNewTagDto> req);

    /**
     * selectNewTagNumsByName:(根据标签名称查询一二级标签tagnum列表，用于页面标签定位). <br/>
     *
     * @author chencheng
     * @param tagName 一二级标签名称
     * @return
     * @since JDK 1.8
     */
    List<String> selectNewTagNumsByName(String tagName);

    /**
     * selectNewTagListGroupByName:(模糊查询所有匹配的一二级标签(根据标签名去重)，用于页面标签定位.). <br/>
     *
     * @author chencheng
     * @param tagName 一二级标签名称
     * @return
     * @since JDK 1.8
     */
    List<JmLayerNewTagDto> selectNewTagListGroupByName(String tagName);

    /**
     * 根据父标签ID 删除
     *
     * @param parentId
     * @return
     */
    List<JmLayerNewTagDto> selectByParentId(Long parentId);

    /**
     * 根据Id 查询
     *
     * @param tagId
     * @return
     */
    JmLayerNewTagDto selectById(Long tagId);
}
