/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.activity.center.api.dto.inter;

import cn.com.duiba.tuia.activity.center.api.constant.HttpMethod;
import cn.com.duiba.tuia.activity.center.api.constant.ParseType;
import cn.com.duiba.tuia.activity.center.api.constant.ProtocolType;
import cn.com.duiba.tuia.activity.center.api.dto.inter.InterfaceDto;
import cn.com.duiba.tuia.activity.center.api.dto.inter.InterfaceHttpEncryptDto;
import cn.com.duiba.tuia.activity.center.api.dto.inter.InterfaceHttpRequestDto;
import cn.com.duiba.tuia.activity.center.api.dto.inter.InterfaceHttpResponseDto;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InterfaceHttpDto
extends InterfaceDto {
    private static final long serialVersionUID = 1L;
    private String url;
    private HttpMethod methodType;
    private ParseType requestType;
    private ParseType responseType;
    private Boolean isTranslate;
    private List<InterfaceHttpRequestDto> request;
    private List<InterfaceHttpResponseDto> response;
    private List<InterfaceHttpEncryptDto> encrypt;
    private Map<Long, InterfaceHttpRequestDto> requestMap;

    public InterfaceHttpDto() {
    }

    public InterfaceHttpDto(Long id, String name, String interfaceCode, ProtocolType protocolType, String description, Boolean isStart, Boolean isDeleted, Boolean isLog) {
        super(id, name, interfaceCode, protocolType, description, isStart, isDeleted, isLog);
    }

    public InterfaceHttpDto(String url, HttpMethod methodType, ParseType requestType, ParseType responseType, Boolean isTranslate, List<InterfaceHttpRequestDto> request, List<InterfaceHttpResponseDto> response, List<InterfaceHttpEncryptDto> encrypt) {
        this.url = url;
        this.methodType = methodType;
        this.requestType = requestType;
        this.responseType = responseType;
        this.isTranslate = isTranslate;
        this.request = request;
        this.response = response;
        this.encrypt = encrypt;
    }

    public InterfaceHttpDto(String name, String interfaceCode, ProtocolType protocolType, String description, Boolean isLog, String url, HttpMethod methodType, ParseType requestType, ParseType responseType, Boolean isTranslate) {
        super(null, name, interfaceCode, protocolType, description, true, false, isLog);
        this.url = url;
        this.methodType = methodType;
        this.requestType = requestType;
        this.responseType = responseType;
        this.isTranslate = isTranslate;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public HttpMethod getMethodType() {
        return this.methodType;
    }

    public void setMethodType(HttpMethod methodType) {
        this.methodType = methodType;
    }

    public ParseType getRequestType() {
        return this.requestType;
    }

    public void setRequestType(ParseType requestType) {
        this.requestType = requestType;
    }

    public ParseType getResponseType() {
        return this.responseType;
    }

    public void setResponseType(ParseType responseType) {
        this.responseType = responseType;
    }

    public Boolean getIsTranslate() {
        return this.isTranslate;
    }

    public void setIsTranslate(Boolean isTranslate) {
        this.isTranslate = isTranslate;
    }

    public List<InterfaceHttpRequestDto> getRequest() {
        return this.request;
    }

    public void setRequest(List<InterfaceHttpRequestDto> request) {
        this.request = request;
    }

    public List<InterfaceHttpResponseDto> getResponse() {
        return this.response;
    }

    public void setResponse(List<InterfaceHttpResponseDto> response) {
        this.response = response;
    }

    public List<InterfaceHttpEncryptDto> getEncrypt() {
        return this.encrypt;
    }

    public void setEncrypt(List<InterfaceHttpEncryptDto> encrypt) {
        this.encrypt = encrypt;
    }

    public InterfaceHttpRequestDto getRequestById(Long id) {
        if (id != null) {
            if (this.requestMap == null) {
                this.generateRequestMap();
            }
            return this.requestMap.get(id);
        }
        return null;
    }

    private synchronized void generateRequestMap() {
        if (this.requestMap == null && this.request != null && !this.request.isEmpty()) {
            this.requestMap = new HashMap<Long, InterfaceHttpRequestDto>();
            for (InterfaceHttpRequestDto dto : this.request) {
                this.requestMap.put(dto.getId(), dto);
            }
        }
    }
}

