package cn.com.duiba.tuia.activity.center.api.constant;

/**
 * ClassName: ActivityOptionType <br/>
 * Function: 奖项类型枚举. <br/>
 * date: 2017年1月13日 下午2:53:09 <br/>
 *
 * @author wubo
 * @version 1.0
 * @since JDK 1.7
 */
public enum ActivityOptionType {
    
    TYPE_COUPON("coupon", "优惠券"), TYPE_LUCKY("lucky", "福袋"), TYPE_NOTHING("nothing", "不关联奖品"),
    TYPE_THANKS("thanks", "谢谢参与"), TYPE_AGAIN("again", "再来一次");

    /** code:奖项类型. */
    private String code;

    /** desc:奖项类型描述. */
    private String desc;

    ActivityOptionType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    /**
     * getCode:(奖项type). <br/>
     * 
     * @return String
     */
    public String getCode() {
        return code;
    }

    /**
     * getDesc:(奖项type描述). <br/>
     * 
     * @return String
     */
    public String getDesc() {
        return desc;
    }

    /**
     * getDescByCode:(根据code获取描述). <br/>
     * 
     * @param code
     * @return
     */
    public static String getDescByCode(String code) {
        String desc = "";
        for (ActivityOptionType temp : ActivityOptionType.values()) {
            if (temp.getCode().equals(code)) {
                desc = temp.getDesc();
            }
        }
        return desc;
    }

}
