/**
 * Project Name:activity-center-api<br>
 * File Name:RemoteEntranceStaticService.java<br>
 * Package Name:cn.com.duiba.tuia.activity.center.api.remoteservice<br>
 * Date:2017年3月31日下午5:06:59<br>
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.<br>
 */

package cn.com.duiba.tuia.activity.center.api.remoteservice;

import java.util.List;

import cn.com.duiba.tuia.activity.center.api.common.PageDto;
import cn.com.duiba.tuia.activity.center.api.dto.EntranceDataDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * ClassName: RemoteEntranceStaticService <br/>
 * date: 2017年3月31日 下午5:06:59 <br/>
 * .
 *
 * @author youhaijun
 * @version
 * @since JDK 1.7
 */
public interface RemoteEntranceStaticService {

    /**
     * 获取活动维度浮标的曝光PV,UV及点击的PV,UV数据. 支持按日期，分页，批量查询
     * 
     * @param start the start
     * @param eng the eng
     * @param activityIds 活动ids
     * @param offset the offset
     * @param max the max
     * @return the dubbo result< page dto< activity buoy data dto>>
     */
    DubboResult<PageDto<EntranceDataDto>> selectActBuoyDataPage(String start, String eng, List<Long> activityIds,
                                                                Integer offset, Integer max);

    /**
     * 查询广告位维度返回拦截到各种页面上的发券量，支持按日期，分页，批量.
     *
     * @param start the start
     * @param eng the eng
     * @param slotIds the slot ids
     * @param offset the offset
     * @param max the max
     * @return the dubbo result< page dto< activity buoy data dto>>
     */
    DubboResult<PageDto<EntranceDataDto>> selectSlotReturnDataPage(String start, String eng, List<Long> slotIds,
                                                                   Integer offset, Integer max);

    /**
     * 查询广告位维度返回拦截到各种页面上的每小时发券量.
     *
     * @param date 查询的日期
     * @param slotId 待查询的广告位
     * @return the dubbo result< list< activity buoy data dto>>
     */
    DubboResult<List<EntranceDataDto>> selectSlotReturnHourData(String date, Long slotId);

}
