package cn.com.duiba.tuia.activity.center.api.cache;

import java.util.concurrent.TimeUnit;

/**
 * ClassName: CacheSpace <br/>
 * Function: 缓存枚举. <br/>
 * Reason: 配置方便. <br/>
 * Attention:注释必须注明缓存的业务，参数维度，缓存的类，不注明者死全家!
 * 缓存key=TAC-key-参数...
 * date: 2017年1月19日 下午8:49:44 <br/>
 *
 * @author wubo
 * @version
 * @since JDK 1.7
 */
public enum CacheSpace {
    /** 活动缓存 维度:id */
    ACTIVITY("01", 30, TimeUnit.SECONDS),

    /** 活动皮肤缓存 维度:活动id */
    ACTIVITY_SKIN("02", 1, TimeUnit.HOURS),

    /** 皮肤模板 维度:skinType */
    SKINTEMPLATE_TYPE("03", 1, TimeUnit.HOURS),

    /** 皮肤模板 维度:id */
    SKINTEMPLATE_ID("04", 1, TimeUnit.HOURS),

    /** 活动每日参与次数 维度：活动id,日期 */
    ACTIVITY_JOIN("05", 1, TimeUnit.DAYS),
    
    /** 引导页详情,包含关联的活动 维度:引导页id*/
    GUIDEPAGE("06",1,TimeUnit.MINUTES),
    
    /** GUIDEPAGESKIN:引导页皮肤,维度:引导页id.*/
    GUIDEPAGE_SKIN("07",10,TimeUnit.MINUTES),
    
    /** 活动详情缓存 维度:id */
    ACTIVITY_DETAIL("08", 30, TimeUnit.SECONDS),
    
    /** 落地页详情 维度:id */
    LAND_DETAIL("09",10,TimeUnit.MINUTES),
    
    /** 最新引导页详情缓存 维度:pageType.*/
    GUIDEPAGE_RECENT("10",5,TimeUnit.MINUTES),

    /** 浮标 维度:id */
    BUOY("11", 5, TimeUnit.MINUTES),

    /** 浮标列表 维度:无 */
    BUOY_ALL("12", 5, TimeUnit.MINUTES),
    
    /** 入口类型概率缓存 维度：概率类型(浮标/返回).*/
    ENTRANCE_PROB("13",5,TimeUnit.MINUTES),
    
    /** 插件皮肤缓存.*/
    PLUGIN_SKIN("14",30,TimeUnit.MINUTES),
    
    /** 插件奖项缓存.*/
    PLUGIN_OPTION("15",10,TimeUnit.MINUTES),
    
    /** 插件皮肤缓存.*/
    PLUGIN("16",10,TimeUnit.MINUTES),
    
    /** 奖项缓存,维度:奖项id,缓存类:PrizeDto (不包含库存值，库存值要实时去库存中心查询)*/
    PRIZE("17",10,TimeUnit.MINUTES),
    
    /** key每次+1，缓存时间根据实际情况制定.*/
    SIMPLE("n++",1,TimeUnit.DAYS);

    private static final String SPACE = "TAC";

    /**
     * 缓存key标识 缓存key=TAC-key标识-参数 注意:key不允许重复
     */
    private String              key;

    /**
     * 缓存时间
     */
    private int                 time;

    /**
     * 时间单位
     */
    private TimeUnit            unit;

    private CacheSpace(String key, int time, TimeUnit unit) {
        this.key = key;
        this.time = time;
        this.unit = unit;
    }

    public String getKey() {
        return key;
    }

    public int getTime() {
        return time;
    }

    public TimeUnit getUnit() {
        return unit;
    }

    public String generatorKey(Object... params) {
        StringBuilder sb = new StringBuilder(SPACE + "-");
        sb.append(key);
        for (Object temp : params) {
            sb.append("-");
            sb.append(temp);
        }
        return sb.toString();
    }
}
