package cn.com.duiba.tuia.activity.center.api.remoteservice;

import cn.com.duiba.tuia.activity.center.api.dto.AlipayParam;
import cn.com.duiba.tuia.activity.center.api.dto.AlipayPrizeDataDto;
import cn.com.duiba.tuia.activity.center.api.dto.AlipayRsp;
import java.util.Date;
import java.util.List;

import cn.com.duiba.tuia.activity.center.api.common.PageDto;
import cn.com.duiba.tuia.activity.center.api.dto.AlipayOrderDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * Created by wubo on 2017/7/10.
 */
public interface RemoteAlipayService {

    DubboResult<Integer> insertAlipayOrder(AlipayOrderDto dto);

    DubboResult<Integer> updateAlipayOrderByOrderId(AlipayOrderDto dto);

    DubboResult<AlipayOrderDto> selectAlipayOrderByOrderId(String orderId);

    DubboResult<PageDto<AlipayOrderDto>> selectAlipayOrderPage(Integer offset, Integer max, List<Integer> status,
                                                               List<Long> activityIds, List<Long> appIds);
/**
     * @Description: selectAlipayOrderByDeviceId 根据设备id查询用户某段时间区间内所有转账记录
     *
     * @Param: [deviceId, start, end]
     * @Return: cn.com.duiba.wolf.dubbo.DubboResult<java.util.List<cn.com.duiba.tuia.activity.center.api.dto.AlipayOrderDto>>
     * @throws:
     * @author: youhaijun
     * @Date:   2017/7/12
     */
    DubboResult<List<AlipayOrderDto>> selectAlipayOrderByDeviceId(String deviceId, Date start, Date end);


    /**
     * @Description: toAccountTransfer 转账接口
     * @Param: [params]
     * @Return: cn.com.duiba.tuia.activity.center.api.dto.AlipayRsp
     * @throws:
     * @author: youhaijun
     * @Date: 2017/7/14
     */
    DubboResult<AlipayRsp> toAccountTransfer(AlipayParam params);

    DubboResult<PageDto<AlipayPrizeDataDto>> selectActivityAlipayData(List<Long> activityIds);


}
