package cn.com.duiba.tuia.activity.center.api.remoteservice;

import cn.com.duiba.tuia.activity.center.api.common.PageDto;
import cn.com.duiba.tuia.activity.center.api.dto.PrizeDto;
import cn.com.duiba.wolf.dubbo.DubboResult;


/**
 * ClassName: RemotePrizeService <br/>
 * Function: 奖项库相关服务. <br/>
 * Reason: . <br/>
 * date: 2017年6月1日 上午10:45:53 <br/>
 *
 * @author wubo
 * @since JDK 1.8
 */
public interface RemotePrizeService {
    
    /**
     * selectPrizeById:(根据id查询). <br/>
     * @param id 奖品id
     * @param includeStock 是否查询库存值(web查询不包含传false，manager查询可包含传true)
     * @return 奖品dto
     */
    DubboResult<PrizeDto> selectPrizeById(Long id,Boolean includeStock);
    
    /**
     * savePrize:(保存奖项). <br/>
     * 有id更新，无id新增。<br/>
     * 新增奖项时，stockChange=库存. <br/>
     * 更新奖项时，stockChange=库存变化值=新设置的库存-老的库存值
     * @param dto 奖品dto
     * @return 奖品id
     */
    DubboResult<Long> savePrize(PrizeDto dto);
    
    /**
     * deletePrize:(根据id删除，软删). <br/>
     * @param id 奖品id
     * @return boolean
     */
    DubboResult<Boolean> deletePrize(Long id);   
    
    /**
     * selectList:(分页查询). <br/>
     * @param id 奖品id
     * @param title 奖品名称
     * @param offset offset
     * @param max max
     * @param includeStock 是否包含库存信息
     * @return PageDto<PrizeDto>
     */
    DubboResult<PageDto<PrizeDto>> selectList(Long id,String title,Integer offset,Integer max,Boolean includeStock);

    /**
     * 分页查询
     * @param id 奖品id
     * @param title 奖品名称
     * @param prizeType 奖品类型
     * @param offset offset
     * @param max max
     * @param includeStock 是否包含库存信息
     * @return PageDto<PrizeDto>
     */
    DubboResult<PageDto<PrizeDto>> selectList(Long id,String title,String prizeType,Integer offset,Integer max,Boolean includeStock);
    
    /**
     * 活动请求奖品库奖品接口.
     * 校验奖品库存 并扣除库存
     * @param prizeId: 奖品ID
     * @param num: num 为null时候扣去1个库存,不为null则扣去num个
    */
    DubboResult<PrizeDto> obtainPrize(Long prizeId,String orderId, Integer num);

    /**
     * 查询支付宝奖品
     * @return dto
     */
    DubboResult<PrizeDto> selectAlipayPrize();
}
