/**
 * Project Name:activity-center-api<br>
 * File Name:PluginOptionDto.java<br>
 * Package Name:cn.com.duiba.tuia.activity.center.api.dto<br>
 * Date:2017年5月9日上午10:28:56<br>
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.<br>
 */

package cn.com.duiba.tuia.activity.center.api.dto;

import cn.com.duiba.tuia.activity.center.api.common.BaseDto;

/**
 * ClassName: PluginOptionDto <br/>
 * 插件工具奖项DTO date: 2017年5月9日 上午10:28:56 <br/>
 * .
 *
 * @author youhaijun
 * @version
 * @since JDK 1.7
 */
public class PluginOptionDto extends BaseDto {

    /** The Constant serialVersionUID. @since JDK 1.6 */
    private static final long serialVersionUID = 4111149344501489349L;

    /** The id. */
    private Long              id;

    /** 奖项名称. */
    private String            title;

    /** 业务ID，当前为插件ID. */
    private Long              businessId;

    /** 业务类型，插件工具时无效. */
    private Integer           businessType;

    /** 广告ID，优惠券奖品时有效. */
    private Long              advertId;

    /** 券码ID. */
    private Long              gid;

    /** 券码类型，广告券默认为4. */
    private Integer           gtype;

    /** 奖项类型，与活动奖项类型保持一致. */
    private String            prizeType;

    /** 库存ID. */
    private Long              stockId;

    /** 库存值. */
    private Integer           stock;

    /** 库存变化值. */
    private Integer           stockChange;

    /** 奖项概率，优惠券有效. */
    private String            rate;

    /** 是否删除. */
    private Boolean           isDeleted;

    /**
     * Gets the id.
     *
     * @return the id
     */
    public Long getId() {
        return id;
    }

    /**
     * Sets the id.
     *
     * @param id the id
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * Gets the title.
     *
     * @return the title
     */
    public String getTitle() {
        return title;
    }

    /**
     * Sets the title.
     *
     * @param title the title
     */
    public void setTitle(String title) {
        this.title = title;
    }

    /**
     * Gets the business id.
     *
     * @return the business id
     */
    public Long getBusinessId() {
        return businessId;
    }

    /**
     * Sets the business id.
     *
     * @param businessId the business id
     */
    public void setBusinessId(Long businessId) {
        this.businessId = businessId;
    }

    /**
     * Gets the business type.
     *
     * @return the business type
     */
    public Integer getBusinessType() {
        return businessType;
    }

    /**
     * Sets the business type.
     *
     * @param businessType the business type
     */
    public void setBusinessType(Integer businessType) {
        this.businessType = businessType;
    }

    /**
     * Gets the advert id.
     *
     * @return the advert id
     */
    public Long getAdvertId() {
        return advertId;
    }

    /**
     * Sets the advert id.
     *
     * @param advertId the advert id
     */
    public void setAdvertId(Long advertId) {
        this.advertId = advertId;
    }

    /**
     * Gets the gid.
     *
     * @return the gid
     */
    public Long getGid() {
        return gid;
    }

    /**
     * Sets the gid.
     *
     * @param gid the gid
     */
    public void setGid(Long gid) {
        this.gid = gid;
    }

    /**
     * Gets the gtype.
     *
     * @return the gtype
     */
    public Integer getGtype() {
        return gtype;
    }

    /**
     * Sets the gtype.
     *
     * @param gtype the gtype
     */
    public void setGtype(Integer gtype) {
        this.gtype = gtype;
    }

    /**
     * Gets the prize type.
     *
     * @return the prize type
     */
    public String getPrizeType() {
        return prizeType;
    }

    /**
     * Sets the prize type.
     *
     * @param prizeType the prize type
     */
    public void setPrizeType(String prizeType) {
        this.prizeType = prizeType;
    }

    /**
     * Gets the stock id.
     *
     * @return the stock id
     */
    public Long getStockId() {
        return stockId;
    }

    /**
     * Sets the stock id.
     *
     * @param stockId the stock id
     */
    public void setStockId(Long stockId) {
        this.stockId = stockId;
    }

    /**
     * Gets the rate.
     *
     * @return the rate
     */
    public String getRate() {
        return rate;
    }

    /**
     * Sets the rate.
     *
     * @param rate the rate
     */
    public void setRate(String rate) {
        this.rate = rate;
    }

    /**
     * Gets the is deleted.
     *
     * @return the checks if is deleted
     */
    public Boolean getIsDeleted() {
        return isDeleted;
    }

    /**
     * Sets the is deleted.
     *
     * @param isDeleted the checks if is deleted
     */
    public void setIsDeleted(Boolean isDeleted) {
        this.isDeleted = isDeleted;
    }

    
    public Integer getStock() {
        return stock;
    }

    
    public void setStock(Integer stock) {
        this.stock = stock;
    }

    
    public Integer getStockChange() {
        return stockChange;
    }

    
    public void setStockChange(Integer stockChange) {
        this.stockChange = stockChange;
    }

}
