package cn.com.duiba.tuia.activity.center.api.constant;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;

/**
 * Created by wubo on 2017/8/16.
 */
public enum LayerSkinType {

    ALIPAY_QUOTA(1,"支付宝-定额"),
    ALIPAY_RANDOM(2,"支付宝-随机"),
    THANKS(3,"谢谢参与"),
    COUPON(4,"广告"),
    RECOMMEND(5,"推荐弹层")

    ;

    private Integer group;
    private Integer type;
    private String  desc;

    LayerSkinType(Integer type, String desc) {
        this.group = SkinGroup.LAYER.getGroup();
        this.type = type;
        this.desc = desc;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    public Integer getGroup() {
        return group;
    }

    public static LayerSkinType getByType(int type) {
        for (LayerSkinType layer : LayerSkinType.values()) {
            if (layer.getType().equals(type)) {
                return layer;
            }
        }
        return null;
    }

    public static String getDescByType(int type) {
        LayerSkinType layer = getByType(type);
        if (layer != null) {
            return layer.getDesc();
        } else {
            return "未定义";
        }
    }

    public static JSONArray getAll() {
        JSONArray jsons = new JSONArray();
        for (LayerSkinType layer : LayerSkinType.values()) {
            JSONObject json = new JSONObject();
            json.put(FieldNameSpace.TYPE, layer.getType());
            json.put(FieldNameSpace.DESC, layer.getDesc());
            jsons.add(json);
        }
        return jsons;
    }

}
