package cn.com.duiba.tuia.activity.center.api.remoteservice;

import cn.com.duiba.tuia.activity.center.api.dto.AlipayParam;
import cn.com.duiba.tuia.activity.center.api.dto.AlipayPrizeDataDto;
import cn.com.duiba.tuia.activity.center.api.dto.AlipayRsp;
import cn.com.duiba.tuia.activity.center.api.dto.req.ReqAliOrderQuery;
import java.util.Date;
import java.util.List;

import cn.com.duiba.tuia.activity.center.api.common.PageDto;
import cn.com.duiba.tuia.activity.center.api.dto.AlipayOrderDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * Created by wubo on 2017/7/10.
 */
public interface RemoteAlipayService {

    DubboResult<Integer> insertAlipayOrder(AlipayOrderDto dto);

    DubboResult<Integer> updateAlipayOrderByOrderId(AlipayOrderDto dto);

    DubboResult<AlipayOrderDto> selectAlipayOrderByOrderId(String orderId);

    DubboResult<PageDto<AlipayOrderDto>> selectAlipayOrderPage(Integer offset, Integer max, List<Integer> status,
                                                               List<Long> activityIds, List<Long> appIds);

    DubboResult<PageDto<AlipayOrderDto>> selectAlipayOrderPage(ReqAliOrderQuery req);

    /**
     * @Description: selectAlipayOrderByDeviceId 根据设备id查询用户某段时间区间内所有转账记录
     *
     * @Param: [deviceId, start, end]
     * @Return: cn.com.duiba.wolf.dubbo.DubboResult<java.util.List<cn.com.duiba.tuia.activity.center.api.dto.AlipayOrderDto>>
     * @throws:
     * @author: youhaijun
     * @Date:   2017/7/12
     */
    DubboResult<List<AlipayOrderDto>> selectAlipayOrderByDeviceId(Long optionId, String deviceId, Date start, Date end);


    /**
     * @Description: toAccountTransfer 转账接口
     * @Param: [params]
     * @Return: cn.com.duiba.tuia.activity.center.api.dto.AlipayRsp
     * @throws:
     * @author: youhaijun
     * @Date: 2017/7/14
     */
    DubboResult<AlipayRsp> toAccountTransfer(AlipayParam params);

    /**
     * 活动Id、时间段查询支付宝直充奖项订单数据统一接口
     * @param activityIds
     * @param startDate  与endDate 同时为null时，直接根据活动id查询
     * @param endDate   与startDate 同时为null时，直接根据活动id查询  只存在同时为空 同时补位空的情况
     * @return
     */
    DubboResult<List<AlipayPrizeDataDto>> selectActivityAlipayData(List<Long> activityIds, String startDate, String endDate);

    /**
     * 查询活动每日数据
     * 返回数据维度奖项id+时间（天）
     * 客户端计算每天的数据总计
     * web展示格式
     *  day1
     *    奖项1
     *    奖项2
     *  day2
     *    奖项1
     *    奖项2
     * @param activityId 活动id
     * @param startDate 开始时间
     * @param endDate 结束时间
     * @return
     */
    DubboResult<List<AlipayPrizeDataDto>> selectActivityDailyAlipayData(Long activityId, Date startDate,Date endDate);


    /***
         * @Description: selectOrderCount 查询分页总数
         *
         * @Param: [req]
         * @Return: cn.com.duiba.wolf.dubbo.DubboResult<java.lang.Integer>
         * @throws:
         * @author: youhaijun
         * @Date:   2017/8/8
         */
    DubboResult<Integer> selectOrderCount(ReqAliOrderQuery req);

    DubboResult<Long> selectTotalAward(Date startDate, Date endDate);
}
