/**
 * Project Name:activity-center-api<br>
 * File Name:RemoteSystemConfigService.java<br>
 * Package Name:cn.com.duiba.tuia.activity.center.api.remoteservice<br>
 * Date:2017年5月26日下午2:59:15<br>
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.<br>
 *
 */
package cn.com.duiba.tuia.activity.center.api.remoteservice;

import cn.com.duiba.tuia.activity.center.api.constant.ConfigKey;
import cn.com.duiba.wolf.dubbo.DubboResult;


/**
 * ClassName: RemoteSystemConfigService <br/>
 * Function: 配置项接口. <br/>
 * Reason: 数据库配置项的相关服务. <br/>
 * date: 2017年5月26日 上午11:36:15 <br/>
 *
 * @author wubo
 * @version 
 * @since JDK 1.8
 */
public interface RemoteSystemConfigService {
    /**
     * selectByKey:(根据key查询配置). <br/>
     * @param key 配置项key
     * @return 配置value
     */
    DubboResult<String> selectByKey(String key);

    /**
     * configBykey:配置
     * @param key 配置项key
     * @param value 配置项值
     * @return true/false
     */
    DubboResult<Boolean> configByKey(ConfigKey key, String value);
}
