/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.activity.center.api.constant;

import java.util.Arrays;
import java.util.List;

public enum AlipayType {
    QUOTA(1, "\u5b9a\u989d"),
    RANDOM(2, "\u968f\u673a"),
    PHYSICAL(3, "\u5b9e\u7269"),
    VIRTUAL_API(10, "API"),
    VIRTUAL_API_0(11, "\u5185\u5bb9\u5145\u503c"),
    VIRTUAL_API_1(12, "\u4efb\u610f\u6570\u5145\u503c"),
    VIRTUAL_TICKET(13, "\u52b5\u7801"),
    VIRTUAL_TICKET_0(14, "\u666e\u901a\u52b5\u7801"),
    VIRTUAL_TICKET_1(15, "\u91cd\u590d\u52b5\u7801"),
    VIRTUAL_TICKET_2(16, "\u94fe\u63a5"),
    VIRTUAL_ACCOUNT(17, "\u8d26\u53f7\u6536\u96c6");

    private Integer type;
    private String desc;
    public static final List<Integer> ALI_TYPE;
    public static final List<Integer> PHYSICAL_TYPE;
    public static final List<Integer> VIRTUAL_TYPE;
    public static final List<Integer> VIRTUAL_API_TYPE;
    public static final List<Integer> VIRTUAL_TICKET_TYPE;

    private AlipayType(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public Integer getType() {
        return this.type;
    }

    public String getDesc() {
        return this.desc;
    }

    public static boolean isAli(Integer type) {
        return ALI_TYPE.contains(type);
    }

    public static boolean isPhysical(Integer type) {
        return PHYSICAL_TYPE.contains(type);
    }

    public static boolean isVirtual(Integer type) {
        return VIRTUAL_TYPE.contains(type);
    }

    public static boolean isVirtualApi(Integer type) {
        return VIRTUAL_API_TYPE.contains(type);
    }

    public static boolean isVirtualTicket(Integer type) {
        return VIRTUAL_TICKET_TYPE.contains(type);
    }

    static {
        ALI_TYPE = Arrays.asList(QUOTA.getType(), RANDOM.getType());
        PHYSICAL_TYPE = Arrays.asList(PHYSICAL.getType());
        VIRTUAL_TYPE = Arrays.asList(VIRTUAL_API.getType(), VIRTUAL_TICKET.getType(), VIRTUAL_ACCOUNT.getType());
        VIRTUAL_API_TYPE = Arrays.asList(VIRTUAL_API_0.getType(), VIRTUAL_API_1.getType());
        VIRTUAL_TICKET_TYPE = Arrays.asList(VIRTUAL_TICKET_0.getType(), VIRTUAL_TICKET_1.getType(), VIRTUAL_TICKET_2.getType());
    }
}

