/**
 * Project Name:activity-center-api<br>
 * File Name:ActivityPluginDto.java<br>
 * Package Name:cn.com.duiba.tuia.activity.center.api.dto<br>
 * Date:2017年5月9日上午10:33:10<br>
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.<br>
 */

package cn.com.duiba.tuia.activity.center.api.dto;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

import org.apache.commons.lang3.StringUtils;

import cn.com.duiba.tuia.activity.center.api.common.BaseDto;
import cn.com.duiba.wolf.utils.DateUtils;

/**
 * ClassName: ActivityPluginDto <br/>
 * 插件工具DTO date: 2017年5月9日 上午10:33:10 <br/>
 * .
 *
 * @author youhaijun
 * @version
 * @since JDK 1.7
 */
public class ActivityPluginDto extends BaseDto {

    /** The Constant serialVersionUID. @since JDK 1.6 */
    private static final long serialVersionUID = -1187766817307412233L;

    /** The id. */
    private Long              id;

    /** 皮肤ID. */
    private Long              skinId;

    /** 插件名称. */
    private String            title;

    /** 插件是否开启，默认关闭. */
    private Boolean           isOpen;

    /** 插件是否删除，预留字段. */
    private Boolean           isDeleted;

    /** 插件自动关闭时间. */
    private Date              autoOffDate;

    /** 出发场景，流量引导页面id，用英文,分隔. */
    private String            scenarios;

    /** 出发事件，在访问某页面第X次出现插件. */
    private Integer           triggerEvent;

    /** 触发时段，格式为：7:9,10:11，表示当天7-9点和10-11点两个时间段. */
    private String            putPeriod;

    /** 是否开启媒体定向列表，0：未开启，1：开启. */
    private Boolean           isDirect;

    /** 定向app，apppId用英文,隔开. */
    private String            directApp;

    /** 定向广告位，slotId用英文,隔开. */
    private String            directSlot;

    /** 触发结果 1：直接发奖 2: 跳转页面，默认为1. */
    private Integer           triggerType;

    /** 跳转页面url，当triggerType=2时候生效. */
    private String            triggerUrl;

    /** 插件类型*/
    private Integer pluginType;

    /** 展示最大次数*/
    private Integer showTime;

    /** 响应式插件：触发次数*/
    private Integer joinTime;

    /** 响应式插件：出现类型*/
    private Integer appearType;

    /** 响应式插件：优先级*/
    private Integer priority ;

    /**
     * Gets the id.
     *
     * @return the id
     */
    public Long getId() {
        return id;
    }

    /**
     * Sets the id.
     *
     * @param id the id
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * Gets the skin id.
     *
     * @return the skin id
     */
    public Long getSkinId() {
        return skinId;
    }

    /**
     * Sets the skin id.
     *
     * @param skinId the skin id
     */
    public void setSkinId(Long skinId) {
        this.skinId = skinId;
    }

    /**
     * Gets the title.
     *
     * @return the title
     */
    public String getTitle() {
        return title;
    }

    /**
     * Sets the title.
     *
     * @param title the title
     */
    public void setTitle(String title) {
        this.title = title;
    }

    /**
     * Gets the is open.
     *
     * @return the checks if is open
     */
    public Boolean getIsOpen() {
        return isOpen;
    }

    /**
     * Sets the is open.
     *
     * @param isOpen the checks if is open
     */
    public void setIsOpen(Boolean isOpen) {
        this.isOpen = isOpen;
    }

    /**
     * Gets the is deleted.
     *
     * @return the checks if is deleted
     */
    public Boolean getIsDeleted() {
        return isDeleted;
    }

    /**
     * Sets the is deleted.
     *
     * @param isDeleted the checks if is deleted
     */
    public void setIsDeleted(Boolean isDeleted) {
        this.isDeleted = isDeleted;
    }

    /**
     * Gets the auto off date.
     *
     * @return the auto off date
     */
    public Date getAutoOffDate() {
        return autoOffDate;
    }

    /**
     * Sets the auto off date.
     *
     * @param autoOffDate the auto off date
     */
    public void setAutoOffDate(Date autoOffDate) {
        this.autoOffDate = autoOffDate;
    }

    /**
     * Gets the scenarios.
     *
     * @return the scenarios
     */
    public String getScenarios() {
        return scenarios;
    }

    /**
     * Sets the scenarios.
     *
     * @param scenarios the scenarios
     */
    public void setScenarios(String scenarios) {
        this.scenarios = scenarios;
    }

    /**
     * Gets the trigger event.
     *
     * @return the trigger event
     */
    public Integer getTriggerEvent() {
        return triggerEvent;
    }

    /**
     * Sets the trigger event.
     *
     * @param triggerEvent the trigger event
     */
    public void setTriggerEvent(Integer triggerEvent) {
        this.triggerEvent = triggerEvent;
    }

    /**
     * Gets the put period.
     *
     * @return the put period
     */
    public String getPutPeriod() {
        return putPeriod;
    }

    /**
     * Sets the put period.
     *
     * @param putPeriod the put period
     */
    public void setPutPeriod(String putPeriod) {
        this.putPeriod = putPeriod;
    }

    /**
     * Gets the direct app.
     *
     * @return the direct app
     */
    public String getDirectApp() {
        return directApp;
    }

    /**
     * Sets the direct app.
     *
     * @param directApp the direct app
     */
    public void setDirectApp(String directApp) {
        this.directApp = directApp;
    }

    public String getDirectSlot() {
        return directSlot;
    }

    public void setDirectSlot(String directSlot) {
        this.directSlot = directSlot;
    }

    /**
     * Gets the trigger type.
     *
     * @return the trigger type
     */
    public Integer getTriggerType() {
        return triggerType;
    }

    /**
     * Sets the trigger type.
     *
     * @param triggerType the trigger type
     */
    public void setTriggerType(Integer triggerType) {
        this.triggerType = triggerType;
    }

    /**
     * Gets the trigger url.
     *
     * @return the trigger url
     */
    public String getTriggerUrl() {
        return triggerUrl;
    }

    /**
     * Sets the trigger url.
     *
     * @param triggerUrl the trigger url
     */
    public void setTriggerUrl(String triggerUrl) {
        this.triggerUrl = triggerUrl;
    }

    public Boolean getIsDirect() {
        return isDirect;
    }

    public void setIsDirect(Boolean isDirect) {
        this.isDirect = isDirect;
    }

    public Integer getPluginType() {
        return pluginType;
    }

    public void setPluginType(Integer pluginType) {
        this.pluginType = pluginType;
    }

    public Integer getShowTime() {
        return showTime;
    }

    public void setShowTime(Integer showTime) {
        this.showTime = showTime;
    }

    public List<PeriodDto> getPeriodList() {
        List<PeriodDto> list = new ArrayList<>();
        if (StringUtils.isEmpty(putPeriod)) {
            return list;
        }
        List<String> periods = new ArrayList<>();
        if (StringUtils.isNotBlank(putPeriod)) {
            String[] array = putPeriod.split(",");
            for (String s : array) {
                periods.add(s);
            }
        }

        for (String str : periods) {
            PeriodDto dto = new PeriodDto();
            String[] strs = str.split(";");
            if (2 > strs.length) {
                continue;
            }
            Calendar cal = Calendar.getInstance();
            cal.set(Calendar.HOUR_OF_DAY, Integer.valueOf(strs[0].split(":")[0]));
            cal.set(Calendar.MINUTE, Integer.valueOf(strs[0].split(":")[1]));
            dto.setStart(DateUtils.calendar2TimeString(cal));
            cal.set(Calendar.HOUR_OF_DAY, Integer.valueOf(strs[1].split(":")[0]));
            cal.set(Calendar.MINUTE, Integer.valueOf(strs[1].split(":")[1]));
            dto.setEnd(DateUtils.calendar2TimeString(cal));
            list.add(dto);
        }
        return list;
    }

    public Integer getJoinTime() {
        return joinTime;
    }

    public void setJoinTime(Integer joinTime) {
        this.joinTime = joinTime;
    }

    public Integer getAppearType() {
        return appearType;
    }

    public void setAppearType(Integer appearType) {
        this.appearType = appearType;
    }

    public Integer getPriority() {
        return priority;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }
}
