/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.activity.center.api.constant;

import java.util.Arrays;
import java.util.List;

public enum AlipayType {
    QUOTA(1, "\u652f\u4ed8\u5b9d\u5b9a\u989d"),
    RANDOM(2, "\u652f\u4ed8\u5b9d\u968f\u673a"),
    PHYSICAL(3, "\u5b9e\u7269"),
    VIRTUAL_API(10, "API"),
    VIRTUAL_API_0(11, "\u5185\u5bb9\u5145\u503c"),
    VIRTUAL_API_1(12, "\u4efb\u610f\u6570\u5145\u503c"),
    VIRTUAL_TICKET(13, "\u52b5\u7801"),
    VIRTUAL_TICKET_0(14, "\u666e\u901a\u52b5\u7801"),
    VIRTUAL_TICKET_1(15, "\u91cd\u590d\u52b5\u7801"),
    VIRTUAL_TICKET_2(16, "\u94fe\u63a5"),
    VIRTUAL_ACCOUNT(17, "\u8d26\u53f7\u6536\u96c6"),
    QB_QUOTA(21, "Q\u5e01\u5b9a\u989d"),
    QB_RANDOM(22, "Q\u5e01\u968f\u673a");

    private Integer type;
    private String desc;
    public static final List<Integer> ALI_TYPE;
    public static final List<Integer> QB_TYPE;
    public static final List<Integer> PHYSICAL_TYPE;
    public static final List<Integer> VIRTUAL_TYPE;
    public static final List<Integer> VIRTUAL_API_TYPE;
    public static final List<Integer> VIRTUAL_TICKET_TYPE;
    public static final List<Integer> VIRTUAL_All_TYPE;

    private AlipayType(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public Integer getType() {
        return this.type;
    }

    public String getDesc() {
        return this.desc;
    }

    public static boolean isAli(Integer type) {
        return ALI_TYPE.contains(type);
    }

    public static boolean isQB(Integer type) {
        return QB_TYPE.contains(type);
    }

    public static boolean isPhysical(Integer type) {
        return PHYSICAL_TYPE.contains(type);
    }

    public static boolean isVirtual(Integer type) {
        return VIRTUAL_TYPE.contains(type);
    }

    public static boolean isVirturalOrSubVirtural(Integer type) {
        return VIRTUAL_All_TYPE.contains(type);
    }

    public static boolean isVirtualApi(Integer type) {
        return VIRTUAL_API_TYPE.contains(type);
    }

    public static boolean isVirtualTicket(Integer type) {
        return VIRTUAL_TICKET_TYPE.contains(type);
    }

    public static String getDesc(Integer type) {
        if (type == null) {
            return "";
        }
        switch (type) {
            case 1: {
                return QUOTA.getDesc();
            }
            case 2: {
                return RANDOM.getDesc();
            }
            case 3: {
                return PHYSICAL.getDesc();
            }
            case 10: {
                return VIRTUAL_API.getDesc();
            }
            case 11: {
                return VIRTUAL_API_0.getDesc();
            }
            case 12: {
                return VIRTUAL_API_1.getDesc();
            }
            case 13: {
                return VIRTUAL_TICKET.getDesc();
            }
            case 14: {
                return VIRTUAL_TICKET_0.getDesc();
            }
            case 15: {
                return VIRTUAL_TICKET_1.getDesc();
            }
            case 16: {
                return VIRTUAL_TICKET_2.getDesc();
            }
            case 17: {
                return VIRTUAL_ACCOUNT.getDesc();
            }
            case 21: {
                return QB_QUOTA.getDesc();
            }
            case 22: {
                return QB_RANDOM.getDesc();
            }
        }
        return "";
    }

    public static List<Integer> getAllAliType() {
        return ALI_TYPE;
    }

    public static List<Integer> getAllPhysicalType() {
        return PHYSICAL_TYPE;
    }

    public static List<Integer> getQbType() {
        return QB_TYPE;
    }

    public static List<Integer> getAllVirtual() {
        return VIRTUAL_All_TYPE;
    }

    static {
        ALI_TYPE = Arrays.asList(QUOTA.getType(), RANDOM.getType());
        QB_TYPE = Arrays.asList(QB_QUOTA.getType(), QB_RANDOM.getType());
        PHYSICAL_TYPE = Arrays.asList(PHYSICAL.getType());
        VIRTUAL_TYPE = Arrays.asList(VIRTUAL_API.getType(), VIRTUAL_TICKET.getType(), VIRTUAL_ACCOUNT.getType());
        VIRTUAL_API_TYPE = Arrays.asList(VIRTUAL_API_0.getType(), VIRTUAL_API_1.getType());
        VIRTUAL_TICKET_TYPE = Arrays.asList(VIRTUAL_TICKET_0.getType(), VIRTUAL_TICKET_1.getType(), VIRTUAL_TICKET_2.getType());
        VIRTUAL_All_TYPE = Arrays.asList(VIRTUAL_API.getType(), VIRTUAL_TICKET.getType(), VIRTUAL_ACCOUNT.getType(), VIRTUAL_API_0.getType(), VIRTUAL_API_1.getType(), VIRTUAL_TICKET_0.getType(), VIRTUAL_TICKET_1.getType(), VIRTUAL_TICKET_2.getType());
    }
}

