package cn.com.duiba.tuia.activity.center.api.constant;

import java.util.Arrays;
import java.util.List;

public enum BalanceRecordType {
                               FIRST_LOGIN(1, "首次登录"),

                               GENERAL_ACTIVITY(2, "普通活动奖励"),

                               WELFARE_ACTIVITY(3, "插件活动奖励"),

                               MISSION(4, "任务奖励"),

                               WITHDRAW(5, "提现");

    private Integer type;
    private String  desc;

    BalanceRecordType(Integer type, String desc) {
        this.type = type;
        this.desc = desc;

    }

    static final List<BalanceRecordType> in = Arrays.asList(FIRST_LOGIN, GENERAL_ACTIVITY, WELFARE_ACTIVITY, MISSION);

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    // 1为收入 2为支出
    public static Integer getChangeType(BalanceRecordType balanceRecordType) {
        if (in.contains(balanceRecordType)) {
            return 1;
        } else {
            return 2;
        }
    }
}
