package cn.com.duiba.tuia.activity.center.api.dto;

import java.util.ArrayList;
import java.util.List;

import cn.com.duiba.tuia.activity.center.api.common.BaseDto;
import org.apache.commons.lang3.StringUtils;

/**
 * Created by wubo on 2017/8/29.
 */
public class GuidePageBlockDto extends BaseDto {

    private static final long serialVersionUID = 1L;

    /**
     * id
     */
    private Long id;

    /**
     * 引导页id
     */
    private Long pageId;

    /**
     * 区域名称
     */
    private String regionName;

    /**
     * 区域类型
     */
    private Integer regionType;

    /**
     * 区块名称
     */
    private String blockName;

    /**
     * 区块类型
     */
    private Integer blockType;

    /**
     * 直投链接
     */
    private String url;

    /**
     * 图片
     */
    private String image;

    /**
     * 广告id
     */
    private String advertIds;

    /**
     * 活动ID、主会场Id
     */
    private String relationIds;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getPageId() {
        return pageId;
    }

    public void setPageId(Long pageId) {
        this.pageId = pageId;
    }

    public String getRegionName() {
        return regionName;
    }

    public void setRegionName(String regionName) {
        this.regionName = regionName;
    }

    public Integer getRegionType() {
        return regionType;
    }

    public void setRegionType(Integer regionType) {
        this.regionType = regionType;
    }

    public String getBlockName() {
        return blockName;
    }

    public void setBlockName(String blockName) {
        this.blockName = blockName;
    }

    public Integer getBlockType() {
        return blockType;
    }

    public void setBlockType(Integer blockType) {
        this.blockType = blockType;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getImage() {
        return image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public List<Long> getListAdvertIds() {
        List<Long> list = new ArrayList<>();
        if (StringUtils.isBlank(advertIds)){
            return list;
        }
        String[] array = advertIds.split(",");

        for (String s : array) {
            list.add(Long.valueOf(s));
        }
        return list;
    }

    public String getAdvertIds() {
        return advertIds;
    }

    public void setAdvertIds(String advertIds) {
        this.advertIds = advertIds;
    }
    public List<Long> getListRelationIds() {
        List<Long> list = new ArrayList<>();
        if (StringUtils.isBlank(relationIds)){
            return list;
        }
        String[] array = relationIds.split(",");

        for (String s : array) {
            list.add(Long.valueOf(s));
        }
        return list;
    }

    public String getRelationIds() {
        return relationIds;
    }

    public void setRelationIds(String relationIds) {
        this.relationIds = relationIds;
    }
}
