package cn.com.duiba.tuia.activity.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.activity.center.api.dto.consumer.BalanceRecordDto;
import cn.com.duiba.tuia.activity.center.api.dto.consumer.req.BalanceRecordAdd;
import cn.com.duiba.tuia.activity.center.api.dto.consumer.req.BalanceRecordMove;
import cn.com.duiba.tuia.activity.center.api.dto.consumer.req.BalanceRecordQueryDto;

import java.util.List;

@AdvancedFeignClient
public interface RemoteBalanceRecordService {

    /**
     * 获取用户的金额变动记录
     * 
     * @param userId 用户id
     * @return 余额记录列表
     */
    List<BalanceRecordDto> list(BalanceRecordQueryDto queryDto);

    /**
     * 财务记录迁移
     * 
     * @param moveRequest 迁移请求
     * @return 迁移结果
     */
    Boolean move(BalanceRecordMove moveRequest);

}
