package cn.com.duiba.tuia.activity.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.activity.center.api.dto.consumer.ConsumerDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * Created by houwen on 26/07/2017.
 */
@AdvancedFeignClient
public interface RemoteTuiaUserService {

    /**
     * 根据APPKEY和设备ID查询, 查询不到就创建一个新用户
     * @param appId
     * @param deviceId
     * @return 用户ID
     */
    DubboResult<Long> findByAppIdAndDeviceId(Long appId, String deviceId);

    /**·
     * 根据media_user_id或者phone来查询用户，查询不到就创建用户
     *  [注意]此接口只提供给金币业务，会创建可登录的用户，普通活动使用findByAppIdAndDeviceId接口
     * @param consumer
     * @return 包含用户密码的用户信息集合
     */
    ConsumerDto findOrCreateConsumer(ConsumerDto consumer);

    /***
         * @Description: findConsumer 根据media_user_id或者phone来查询用户
         *
         * @Param: [req]
         * @Return: cn.com.duiba.tuia.activity.center.api.dto.consumer.ConsumerDto，没有返回null
         * @throws:
         * @author: youhaijun
         * @Date:   2017/12/13
         */
    ConsumerDto findConsumer(ConsumerDto req);

    Boolean updateConsumer(ConsumerDto req);
}
