package cn.com.duiba.tuia.activity.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.activity.center.api.constant.BalanceType;
import cn.com.duiba.tuia.activity.center.api.dto.ActivityWinOrderDto;
import cn.com.duiba.tuia.activity.center.api.dto.consumer.UserBalanceDto;
import cn.com.duiba.tuia.activity.center.api.dto.consumer.req.BalanceRecordAdd;
import cn.com.duiba.tuia.activity.center.api.dto.consumer.req.BalanceWithdrawReq;
import cn.com.duiba.tuia.activity.center.api.exception.ActivityCenterException;

import java.util.Date;

@AdvancedFeignClient
public interface RemoteUserBalanceService {

    /**
     * 创建用户金额帐号
     * 
     * @param userId 用户id
     * @param type 账户类型
     * @return 金额账户id
     */
    Long createBalanceAccount(Long userId, BalanceType type);

    /**
     * 根据用户id获取金额账户列表
     * 
     * @param userId 用户id
     * @return 用户金额列表
     */
    UserBalanceDto getByType(Long userId, BalanceType type);

    /**
     * 更新货币账户余额.这个方法还会记录货币账户的明细
     *
     * @return 更新结果 true-成功 false-失败
     */
    Boolean updateAmount(BalanceRecordAdd adder);

    /**
     * 获取余额
     * 
     * @param userId 用户id
     * @param type 账户类型
     * @return 余额
     */
    Long getAmount(Long userId, BalanceType type);

    /**
     * 现金钱包提现
     *
     * @param req
     * @return
     */
    ActivityWinOrderDto cashWithdraw(BalanceWithdrawReq req) throws ActivityCenterException;

    /**
     * 现金钱包提现 - 管理端重试
     *
     * @param date
     * @param orderId
     * @param aliName
     * @param aliAccount
     * @return
     */
    ActivityWinOrderDto retryCashWithdraw(Date date, String orderId, String aliName, String aliAccount) throws ActivityCenterException;

}
