/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.activity.center.api.constant;

import cn.com.duiba.tuia.activity.center.api.common.Probability;
import cn.com.duiba.tuia.activity.center.api.constant.SkinGroup;
import cn.com.duiba.tuia.activity.center.api.util.Prob;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum LayerSkinType {
    ALIPAY_QUOTA(1, "\u652f\u4ed8\u5b9d-\u5b9a\u989d"),
    ALIPAY_RANDOM(2, "\u652f\u4ed8\u5b9d-\u968f\u673a"),
    THANKS(3, "\u8c22\u8c22\u53c2\u4e0e"),
    COUPON(4, "\u5e7f\u544a"),
    RECOMMEND(5, "\u63a8\u8350\u5f39\u5c42"),
    PHYSICAL(6, "\u5b9e\u7269\u5f39\u5c42"),
    VIRTUAL(7, "\u865a\u62df\u5956\u54c1\u5f39\u5c42"),
    QB_QUOTA(8, "\u817e\u8bafQB-\u5b9a\u989d"),
    QB_RANDOM(9, "\u817e\u8bafQB-\u968f\u673a"),
    BILL_QUOTA(10, "\u8bdd\u8d39-\u5b9a\u989d"),
    BILL_RANDOM(11, "\u8bdd\u8d39-\u968f\u673a"),
    CUSTOM_3341(21, "\u5b9a\u5236\u5f39\u5c421(3341)"),
    CUSTOM_5371(22, "\u5b9a\u5236\u5f39\u5c422(5371)"),
    CUSTOM_3340(23, "\u5b9a\u5236\u5f39\u5c423(3340)"),
    CUSTOM_1983(24, "\u5b9a\u5236\u5f39\u5c424(1983)"),
    THANKS_STYLE1(31, "\u8c22\u8c22\u53c2\u4e0e1"),
    THANKS_STYLE2(32, "\u8c22\u8c22\u53c2\u4e0e2");

    private Integer group = SkinGroup.LAYER.getGroup();
    private Integer type;
    private String desc;
    private static final Prob<LayerSkinType> thankLayers;
    private static List<Integer> constantTypes;
    private static Map<Long, Integer> customSkin;
    private static Map<Integer, LayerSkinType> map;

    private LayerSkinType(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public Integer getType() {
        return this.type;
    }

    public String getDesc() {
        return this.desc;
    }

    public Integer getGroup() {
        return this.group;
    }

    public static Integer getRandomThanks() {
        return thankLayers.getPercentRandom().getType();
    }

    public static Integer getCustomSkinType(Long activityId) {
        if (activityId == null) {
            return null;
        }
        return customSkin.get(activityId);
    }

    public static List<Integer> getConstantSkinTypes() {
        return constantTypes;
    }

    public static LayerSkinType getByType(int type) {
        return map.get(type);
    }

    public static String getDescByType(int type) {
        LayerSkinType layer = LayerSkinType.getByType(type);
        if (layer != null) {
            return layer.getDesc();
        }
        return "\u672a\u5b9a\u4e49";
    }

    public static JSONArray getAll() {
        JSONArray jsons = new JSONArray();
        for (LayerSkinType layer : LayerSkinType.values()) {
            JSONObject json = new JSONObject();
            json.put("type", (Object)layer.getType());
            json.put("desc", (Object)layer.getDesc());
            jsons.add((Object)json);
        }
        return jsons;
    }

    static {
        thankLayers = new Prob();
        thankLayers.put(THANKS_STYLE1, new Probability(50));
        thankLayers.put(THANKS_STYLE2, new Probability(50));
        constantTypes = new ArrayList<Integer>();
        constantTypes.add(ALIPAY_QUOTA.getType());
        constantTypes.add(ALIPAY_RANDOM.getType());
        constantTypes.add(PHYSICAL.getType());
        constantTypes.add(VIRTUAL.getType());
        constantTypes.add(QB_QUOTA.getType());
        constantTypes.add(QB_RANDOM.getType());
        constantTypes.add(BILL_QUOTA.getType());
        constantTypes.add(BILL_RANDOM.getType());
        constantTypes.add(THANKS.getType());
        constantTypes.add(RECOMMEND.getType());
        customSkin = new HashMap<Long, Integer>();
        customSkin.put(5534L, CUSTOM_3341.getType());
        customSkin.put(5908L, CUSTOM_3341.getType());
        customSkin.put(5537L, CUSTOM_3341.getType());
        customSkin.put(5226L, CUSTOM_3341.getType());
        customSkin.put(5813L, CUSTOM_3341.getType());
        customSkin.put(5903L, CUSTOM_3341.getType());
        customSkin.put(5592L, CUSTOM_3341.getType());
        customSkin.put(5650L, CUSTOM_3341.getType());
        customSkin.put(5709L, CUSTOM_5371.getType());
        customSkin.put(5887L, CUSTOM_5371.getType());
        customSkin.put(4118L, CUSTOM_5371.getType());
        customSkin.put(5896L, CUSTOM_5371.getType());
        customSkin.put(5912L, CUSTOM_5371.getType());
        customSkin.put(5270L, CUSTOM_5371.getType());
        customSkin.put(5711L, CUSTOM_5371.getType());
        customSkin.put(5868L, CUSTOM_3340.getType());
        customSkin.put(5278L, CUSTOM_3340.getType());
        customSkin.put(5881L, CUSTOM_3340.getType());
        customSkin.put(5199L, CUSTOM_3340.getType());
        customSkin.put(4573L, CUSTOM_3340.getType());
        customSkin.put(4881L, CUSTOM_3340.getType());
        customSkin.put(5906L, CUSTOM_3340.getType());
        customSkin.put(5910L, CUSTOM_3340.getType());
        customSkin.put(675L, CUSTOM_1983.getType());
        customSkin.put(5040L, CUSTOM_1983.getType());
        customSkin.put(1092L, CUSTOM_1983.getType());
        customSkin.put(5918L, CUSTOM_1983.getType());
        customSkin.put(5913L, CUSTOM_1983.getType());
        customSkin.put(5885L, CUSTOM_1983.getType());
        customSkin.put(5882L, CUSTOM_1983.getType());
        customSkin.put(5201L, CUSTOM_1983.getType());
        customSkin.put(5227L, CUSTOM_1983.getType());
        customSkin.put(5283L, CUSTOM_1983.getType());
        map = new HashMap<Integer, LayerSkinType>();
        for (LayerSkinType layer : LayerSkinType.values()) {
            map.put(layer.getType(), layer);
        }
    }
}

