/**
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 */
package cn.com.duiba.tuia.activity.center.api.dto;

import java.io.Serializable;
import java.util.List;

/**
 * 描述:
 *
 * @version v1.0
 * @auther guopengfei@duiba.com.cn
 * @date 2017/12/12 17:06
 */
public class GuidePageMoneyConfigDto implements Serializable {
    private static final long serialVersionUID = 1577621524533092974L;

    private Long id;
    private Long pageId;
    private Long dailyLimit;
    private Integer dailyTimes;
    private String rate;
    private Long minAmount;
    private Long maxAmount;
    /**
     * @see cn.com.duiba.tuia.activity.center.api.constant.RewardDirectType
     */
    private Integer rewardRegion;
    private List<Regions> regions;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getPageId() {
        return pageId;
    }

    public void setPageId(Long pageId) {
        this.pageId = pageId;
    }

    public Long getDailyLimit() {
        return dailyLimit;
    }

    public void setDailyLimit(Long dailyLimit) {
        this.dailyLimit = dailyLimit;
    }

    public Integer getDailyTimes() {
        return dailyTimes;
    }

    public void setDailyTimes(Integer dailyTimes) {
        this.dailyTimes = dailyTimes;
    }

    public String getRate() {
        return rate;
    }

    public void setRate(String rate) {
        this.rate = rate;
    }

    public Long getMinAmount() {
        return minAmount;
    }

    public void setMinAmount(Long minAmount) {
        this.minAmount = minAmount;
    }

    public Long getMaxAmount() {
        return maxAmount;
    }

    public void setMaxAmount(Long maxAmount) {
        this.maxAmount = maxAmount;
    }

    public Integer getRewardRegion() {
        return rewardRegion;
    }

    public void setRewardRegion(Integer rewardRegion) {
        this.rewardRegion = rewardRegion;
    }

    public List<Regions> getRegions() {
        return regions;
    }

    public void setRegions(List<Regions> regions) {
        this.regions = regions;
    }

    public static class Regions implements Serializable {

        private String regionName;

        private String blockName;

        public String getRegionName() {
            return regionName;
        }

        public void setRegionName(String regionName) {
            this.regionName = regionName;
        }

        public String getBlockName() {
            return blockName;
        }

        public void setBlockName(String blockName) {
            this.blockName = blockName;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            Regions regions = (Regions) o;

            if (regionName != null ? !regionName.equals(regions.regionName) : regions.regionName != null) return false;
            return blockName != null ? blockName.equals(regions.blockName) : regions.blockName == null;
        }

        @Override
        public int hashCode() {
            int result = regionName != null ? regionName.hashCode() : 0;
            result = 31 * result + (blockName != null ? blockName.hashCode() : 0);
            return result;
        }
    }
}
