package cn.com.duiba.tuia.activity.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.activity.center.api.common.PageDto;
import cn.com.duiba.tuia.activity.center.api.constant.GameType;
import cn.com.duiba.tuia.activity.center.api.dto.GameAdvertDto;
import cn.com.duiba.tuia.activity.center.api.dto.GameConfigDto;
import java.util.List;

/**
 * 推啊游戏服务
 *
 * Created by Administrator on 2018/1/23.
 */
@AdvancedFeignClient
public interface RemoteGameService {

    /***
         * @Description: saveGameConfig
         * 带id则为update 否则为insert
         * @Param: [gameConfigDto]
         * @Return: java.lang.Integer
         * @throws:
         * @author: youhaijun
         * @Date:   2018/1/23
         */
    Long saveGameConfig(GameConfigDto gameConfigDto);

    Integer deleteGameConfig(Long id);

    GameConfigDto selectGame(Long id);

    PageDto<GameConfigDto> selectGameList(Integer offset, Integer max, Long id, String title, GameType type);

    List<GameAdvertDto> getAdvertByGame(Long gameId);

    Integer saveBatchAdvert(List<GameAdvertDto> gameAdvertDtos);

    Integer deleteAdvertByGameId(Long gameId);

    /**
     *
     * @param gameIds 游戏ID集合
     * @return 所有可用活动集合，去除删除和关闭的游戏
     */
    List<GameConfigDto> selectGameListByIds(List<Long> gameIds);
}
