package cn.com.duiba.tuia.activity.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.activity.center.api.dto.UserTopRankDto;

@AdvancedFeignClient
public interface RemoteUserTopRankService {

    /**
     * 根据用户ID查询分数信息
     * @param userId
     * @return
     */
    UserTopRankDto selectByUserId(Long userId);

    /**
     * 更新用户分数
     * @param userId
     * @param score
     * @return
     */
    Integer updateByUserId(Long userId, Long score);

    /**
     * 插入用户分数
     * @param dto
     * @return
     */
    Integer insert(UserTopRankDto dto);
}
