package cn.com.duiba.tuia.activity.center.api.dto;

import cn.com.duiba.tuia.activity.center.api.constant.ErrorCode;
import cn.com.duiba.tuia.activity.center.api.exception.ActivityCenterException;
import cn.com.duiba.tuia.activity.center.api.exception.ActivityCenterRuntimeException;

/**
 * 目前推啊订单表里的所有的activity_type 的分类
 *
 * 此表由于多种系统公用，切各个系统种的type有多种，所以给
 * @author lichao 2018/5/18
 */
public enum ActivityTypeNum {

    ACTIVITY(0,2000),//推啊活动
    PLUGIN(2000,3000),//推啊插件
    GAME(6000,7000),//游戏
    YOUTUIACTIVITY(8000,9000)//友推活动
    ;

    private int min;

    private int max;

    ActivityTypeNum(int min, int max) {
        this.min = min;
        this.max = max;
    }

    /**
     * 获取本系统中的应对应的type
     * @param myType
     * @return
     */
    public int getMyRealType(int myType){
        int result = this.getMin()+myType;
        if(result>this.getMax()){
            throw new ActivityCenterRuntimeException(ErrorCode.E0103010.getErrorCode(),ErrorCode.E0103010.getDesc()+","+this.name()+","+myType);
        }
        return result;

    }

    public boolean isType(int activityType){
        return activityType >= this.getMin() && activityType < this.getMax();
    }

    public int getMin() {
        return min;
    }

    public void setMin(int min) {
        this.min = min;
    }

    public int getMax() {
        return max;
    }

    public void setMax(int max) {
        this.max = max;
    }
}
