package cn.com.duiba.tuia.activity.center.api.constant;

import org.apache.commons.lang3.RandomUtils;

/**
 * [种红包]奖励枚举
 *
 * @author zhangbaiqiang
 * @date 2018/11/12
 */
public enum PlantPrizeType {

    COUPON(1, "券"),
    CASH(2, "现金"),
    LAND(3, "解锁土地"),
    SEED(4, "解锁种子"),
    BLOCK(5, "区块");

    private Integer type;
    private String  desc;

    PlantPrizeType(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    /**
     * 计算中奖类型
     *
     * @param couponProb 券概率(如果是70%，则传入70)
     * @return 中奖类型
     */
    public static PlantPrizeType randomType(int couponProb) {
        return RandomUtils.nextInt(1, 101) <= couponProb ? PlantPrizeType.COUPON : PlantPrizeType.CASH;
    }
}
