/**
 * Project Name:activity-center-api<br>
 * File Name:RemoteGuidePageService.java<br>
 * Package Name:cn.com.duiba.tuia.activity.center.api.remoteservice<br>
 * Date:2017年3月3日下午2:16:27<br>
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.<br>
 */

package cn.com.duiba.tuia.activity.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.activity.center.api.common.PageDto;
import cn.com.duiba.tuia.activity.center.api.dto.*;
import cn.com.duiba.tuia.activity.center.api.dto.req.ReqDirectBlock;
import cn.com.duiba.wolf.dubbo.DubboResult;
import org.springframework.web.bind.annotation.RequestMapping;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * ClassName: RemoteGuidePageService <br/>
 * 引导页相关dubbo接口 date: 2017年3月3日 下午2:16:27 <br/>.
 *
 * @author youhaijun
 * @version
 * @since JDK 1.6
 */
@AdvancedFeignClient
public interface RemoteGuidePageService {

    /**
     * Save guide page skin.
     *
     * @param req the req
     * @return the dubbo result< boolean>
     */
    DubboResult<Long> saveGuidePageSkin(GuidePageSkinDto req);

    /**
     * Delete guide page skin.
     *
     * @param id the id
     * @return the dubbo result< boolean>
     */
    DubboResult<Boolean> deleteGuidePageSkin(Long id);

    /**
     * Gets the guide page skin list.
     *
     * @param offset the offset
     * @param max the max
     * @return the guide page skin list
     */
    DubboResult<PageDto<GuidePageSkinDto>> getGuidePageSkinList(Integer offset, Integer max);
    
    /**
     * getGuidePageSkinList:(根据类型查询皮肤). <br/>
     * @param suitableType
     * @return
     */
    @RequestMapping("getGuidePageSkinListSuit")
    DubboResult<List<GuidePageSkinDto>> getGuidePageSkinList(Integer suitableType);

    /**
     * 根据类型查询皮肤
     * <p>
     * 主要区分普通直投页和现金钱包直投页
     *
     * @param suitableType
     * @param directType 0-普通直投页 1-现金直投页
     * @return
     */
    List<GuidePageSkinDto> getGuidePageSkinListByType(Integer suitableType, Integer directType);

    /**
     * Gets the guide page skin detail.
     *
     * @param id the id
     * @return the guide page skin detail
     */
    DubboResult<GuidePageSkinDto> getGuidePageSkinDetail(Long id);

    /**
     * Save guide page.
     *
     * @param req the req
     * @return the dubbo result< boolean>
     */
    DubboResult<Long> saveGuidePage(GuidePageDto req);

    /**
     * Delete guide page.
     *
     * @param id the id
     * @return the dubbo result< boolean>
     */
    DubboResult<Boolean> deleteGuidePage(Long id);

    /**
     * Gets the guide page detail.
     *
     * @param id the id
     * @return the guide page detail
     */
    DubboResult<GuidePageDto> getGuidePageDetail(Long id);

    /**
     * 获取引导页统计数据.
     *
     * @param id 根据引导页ID搜索
     * @param title 根据引导页名称模糊搜索
     * @param offset 分页偏移量
     * @param max 分页最大限制
     * @param start 开始日期，没有开始日期则查全部
     * @param end 结束日期，没有结束日期则查询到当天
     * @return the guide page data
     */
    DubboResult<PageDto<GuidePageDataDto>> getGuidePageData(Long id, String title, Integer offset, Integer max,Date start, Date end);

    /**
     * 获取引导页统计数据.
     *
     * @param id 根据引导页ID搜索
     * @param title 根据引导页名称模糊搜索
     * @param pageType 引导页类型
     * @param offset 分页偏移量
     * @param max 分页最大限制
     * @param start 开始日期，没有开始日期则查全部
     * @param end 结束日期，没有结束日期则查询到当天
     * @return the guide page data
     */
    @RequestMapping("getGuidePageDataNew")
    DubboResult<PageDto<GuidePageDataDto>> getGuidePageData(Long id, String title,Integer pageType, Integer offset, Integer max,Date start, Date end);
    
    /**
     * isRelateGuidePage:(活动是否关联引导页). <br/>
     *
     * @param activityId the activity id
     * @return the dubbo result< boolean>
     */
    DubboResult<Boolean> isRelateGuidePage(Long activityId);
    
    /**
     * isRelateGuidePage:(皮肤是否关联引导页). <br/>
     *
     * @param skinId the skin id
     * @return the dubbo result< boolean>
     */
    DubboResult<Boolean> isSkinRelateGuidePage(Long skinId);


    /**
     * isRelateGuidePage:(浮标是否关联引导页). <br/>
     *
     * @param buoyId the buoyID
     * @return the dubbo result< boolean>
     */
    DubboResult<Boolean> isBuoyRelateGuidePage(Long buoyId);

    /**
     * getGuidePageList:(id批量查询). <br/>
     * @param ids
     * @return
     */
    DubboResult<List<GuidePageDto>> getGuidePageList(List<Long> ids);
    
    /**
     * getRecentGuidePage:(获取最新的引导页的id). <br/>
     * @param pageType
     * @return
     */
    DubboResult<Long> getRecentGuidePage(Integer pageType);

    /**
     * 设置默认直投页
     * @param pageId 直投页id
     * @return true/false
     */
    DubboResult<Boolean> setDefaultDirectPage(Long pageId);

    /**
     * 获取默认直投页
     * @return
     */
    DubboResult<GuidePageDto> getDefaultDirectPage();

    /**
     * 根据浮标id获取相关联流量引导页的ID
     * @param buoyId
     * @author zhou_wb
     * @return
     */
    DubboResult<List<Long>> selectBuoyRelateGuidePage(Long buoyId);
    /***
         * @Description: saveDirectBlock 保存直投页区块信息
         *
         * @Param: [dto]
         * @Return: cn.com.duiba.wolf.dubbo.DubboResult<java.lang.Boolean>
         * @throws:
         * @author: youhaijun
         * @Date:   2017/8/30
         */
    DubboResult<Boolean> saveDirectBlock(ReqDirectBlock dto);

    /***
         * @Description: selectDirectBlock 查询直投页区块信息
         *
         * @Param: [pageId]
         * @Return: cn.com.duiba.wolf.dubbo.DubboResult<cn.com.duiba.tuia.activity.center.api.dto.GuidePageBlockDto>
         * @throws:
         * @author: youhaijun
         * @Date:   2017/8/30
         */
    @RequestMapping("selectDirectBlockLong")
    DubboResult<List<GuidePageBlockDto>> selectDirectBlock(Long pageId);

    /**
     * 删除推广计划为主会场时校验直投页区块是否已配置
     * @param pageId
     * @param blockType
     * @return
     */
    DubboResult<List<GuidePageBlockDto>> selectDirectBlock(Long pageId, Integer blockType);

    /**
     * 通过pageId获取直投页零钱奖项
     *
     * @param pageId
     * @return
     */
    DubboResult<GuidePageMoneyConfigDto> getGuidePageMoneyConfigDto(Long pageId);

    /**
     * 查询主会场关联的活动的所有标签
     * 手机端专用，有缓存
     * @param pageIds 主会场id
     * @return
     */
    Map<Long,Set<String>> getMainMeetTags(List<Long> pageIds);

    /**
     * 通过名称查找直投页
     *
     * @param title
     * @return
     */
    List<GuidePageDto> getGuidePageDtoByTitle(Integer pageType, String title);

    /**
     * 通过page id查询数据库
     * @param pageId
     * @return
     */
    GuidePageDto getGuidePageDtoById(Long pageId);

    /**
     * 批量查询主会场关联的活动
     * @param ids 主会场ids
     * @return 活动id list
     */
    List<Long> selectActivityIdsByMainMeetIds(List<Long> ids);
}
