package cn.com.duiba.tuia.activity.center.api.constant;

import cn.com.duiba.tuia.activity.center.api.dto.plant.PlantSeedDto;
import org.apache.commons.lang3.RandomUtils;

import java.util.Objects;

/**
 * [种红包]种子类型枚举
 *
 * @author zhangbaiqiang
 * @date 2018/11/11
 */
public enum PlantSeedType {

    SEED_ONE(1, 10, 10, "0~1元红包"),
    SEED_FIVE(5, 5, 20, "0~5元红包"),
    SEED_TEN(10, 3, 30, "0~10元红包"),
    SEED_IPHONE(20, 1, 50, "0~iPhone红包"),
    ;

    /**
     * 类型
     */
    private Integer type;

    /**
     * 当日默认库存
     */
    private Integer stock;

    /**
     * 金币单价
     */
    private Integer cost;

    /**
     * 描述
     */
    private String  desc;

    PlantSeedType(Integer type, Integer stock, Integer cost, String desc) {
        this.type = type;
        this.stock = stock;
        this.cost = cost;
        this.desc = desc;
    }

    public Integer getType() {
        return type;
    }

    public Integer getStock() {
        return stock;
    }

    public Integer getCost() {
        return cost;
    }

    public String getDesc() {
        return desc;
    }

    /**
     * 计算种子的成熟时间
     *
     * @param times 当天第几次种
     * @return 成熟时间(秒)
     */
    public int countMatureTime(int times) {
        int matureTime = 0;
        switch (this) {
            case SEED_ONE:
                if (times <= 3) {
                    matureTime = RandomUtils.nextInt(5, 11);
                } else if (times <= 6) {
                    matureTime = RandomUtils.nextInt(30, 61);
                } else {
                    matureTime = RandomUtils.nextInt(300, 901);
                }
                break;
            case SEED_FIVE:
                matureTime = RandomUtils.nextInt(1200, 2401);
                break;
            case SEED_TEN:
                matureTime = RandomUtils.nextInt(3600, 7201);
                break;
            case SEED_IPHONE:
                matureTime = RandomUtils.nextInt(10800, 18001);
                break;
            default:
                break;
        }
        return matureTime;
    }

    /**
     * 获取种子的金币单价
     *
     * @param type 种子类型
     * @return 金币单价
     */
    public static Integer getCostByType(Integer type) {
        for (PlantSeedType typeEnum : values()) {
            if (Objects.equals(typeEnum.getType(), type)) {
                return typeEnum.getCost();
            }
        }
        return 0;
    }

    /**
     * 获取种子的枚举
     *
     * @param type 种子类型
     * @return 枚举
     */
    public static PlantSeedType valueOf(Integer type) {
        for (PlantSeedType typeEnum : values()) {
            if (Objects.equals(typeEnum.getType(), type)) {
                return typeEnum;
            }
        }
        return null;
    }

    /**
     * 枚举转Dto
     */
    public PlantSeedDto toDto() {
        return new PlantSeedDto()
                .setType(this.getType())
                .setUnlock(false)
                .setStock(this.getStock());
    }
}
