package cn.com.duiba.tuia.activity.center.api.dto.plant;

import java.io.Serializable;
import java.util.Date;

/**
 * [种红包]种子Dto
 *
 * @author zhangbaiqiang
 * @date 2018/11/11
 */
public class PlantSeedDto implements Serializable {
    private static final long serialVersionUID = -5477232603427913272L;

    /**
     * 种子编号
     */
    private Long id;

    /**
     * 种子类型
     *
     * {@link cn.com.duiba.tuia.activity.center.api.constant.PlantSeedType}
     */
    private Integer type;

    /**
     * 种子标识
     *
     * {@link cn.com.duiba.tuia.activity.center.api.constant.PlantSeedFlagEnum}
     */
    private Integer flag;

    /**
     * 成熟倒计时(秒)
     */
    private Long matureCountdown;

    /**
     * 是否已经成熟
     */
    private Boolean isMatured;

    /**
     * 种植时间
     */
    private Date gmtCreate;

    /**
     * 是否已经解锁
     */
    private Boolean isUnlock;

    /**
     * 当天种子库存
     */
    private Integer stock;

    public Long getId() {
        return id;
    }

    public PlantSeedDto setId(Long id) {
        this.id = id;
        return this;
    }

    public Integer getType() {
        return type;
    }

    public PlantSeedDto setType(Integer type) {
        this.type = type;
        return this;
    }

    public Integer getFlag() {
        return flag;
    }

    public PlantSeedDto setFlag(Integer flag) {
        this.flag = flag;
        return this;
    }

    public Long getMatureCountdown() {
        return matureCountdown;
    }

    public PlantSeedDto setMatureCountdown(Long matureCountdown) {
        this.matureCountdown = matureCountdown;
        return this;
    }

    public Boolean getMatured() {
        return isMatured;
    }

    public PlantSeedDto setMatured(Boolean matured) {
        isMatured = matured;
        return this;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public PlantSeedDto setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
        return this;
    }

    public Boolean getUnlock() {
        return isUnlock;
    }

    public PlantSeedDto setUnlock(Boolean unlock) {
        isUnlock = unlock;
        return this;
    }

    public Integer getStock() {
        return stock;
    }

    public PlantSeedDto setStock(Integer stock) {
        this.stock = stock;
        return this;
    }
}
