package cn.com.duiba.tuia.activity.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.activity.center.api.dto.plant.PlantDto;
import cn.com.duiba.tuia.activity.center.api.dto.plant.PlantUserReq;
import cn.com.duiba.tuia.activity.center.api.exception.ActivityCenterException;

/**
 * [种红包]Remote接口
 *
 * @author zhangbaiqiang
 * @date 2018/11/11
 */
@AdvancedFeignClient
public interface RemotePlantService {

    /**
     * 签到
     *
     * @param req 用户参数
     * @return 种红包所有信息
     * @throws ActivityCenterException
     */
    PlantDto sign(PlantUserReq req) throws ActivityCenterException;

    /**
     * 种红包
     *
     * @param req 用户参数
     * @param landId 土地编号
     * @param seedType 种子类型
     * @return 用户信息、土地信息、种子仓库
     * @throws ActivityCenterException
     */
    PlantDto plant(PlantUserReq req, Integer landId, Integer seedType) throws ActivityCenterException;

    /**
     * 采摘红包
     *
     * @param req 用户参数
     * @param seedId 种子编号
     * @return 用户信息，奖励信息
     * @throws ActivityCenterException
     */
    PlantDto pick(PlantUserReq req, Long seedId) throws ActivityCenterException;

    /**
     * 提现
     *
     * @param req 用户参数
     * @return 种红包用户信息
     * @throws ActivityCenterException
     */
    PlantDto withdraw(PlantUserReq req) throws ActivityCenterException;
}
