package cn.com.duiba.tuia.activity.center.api.constant.adx;

import org.apache.commons.lang3.StringUtils;

import java.util.stream.Stream;

/**
 * 小米广告位规格枚举
 * @Author chensong
 * @Create 2019-03-27
 */
public enum XiaoMiSpecEnum {

    XIAOMI001("XIAOMI001", "非标广告位"),

    XIAOMI002("XIAOMI002", "横幅"),

    XIAOMI003("XIAOMI003", "开屏广告"),

    XIAOMI004("XIAOMI004", "信息流"),

    XIAOMI005("XIAOMI004","悬浮球");

    private String specCode;

    private String desc;

    private XiaoMiSpecEnum(String specCode, String desc) {
        this.specCode = specCode;
        this.desc = desc;
    }

    public String getSpecCode() {
        return specCode;
    }

    public String getDesc() {
        return desc;
    }

    public static XiaoMiSpecEnum getByCode(String code) {
        return StringUtils.isBlank(code) ? null
                : Stream.of(XiaoMiSpecEnum.values())
                        .filter(item -> StringUtils.equals(code, item.getSpecCode()))
                        .findFirst().orElse(null);
    }
}
