package cn.com.duiba.tuia.activity.center.api.remoteservice.adx;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.activity.center.api.common.PageDto;
import cn.com.duiba.tuia.activity.center.api.dto.adx.IdeaPictureDto;
import cn.com.duiba.tuia.activity.center.api.dto.adx.ResourceIdeaDto;
import cn.com.duiba.tuia.activity.center.api.dto.req.IdeaSortReq;
import cn.com.duiba.tuia.activity.center.api.dto.req.ResourceIdeaPageReq;
import cn.com.duiba.tuia.activity.center.api.dto.rsp.ResourceIdeaThreeRsp;

import java.util.List;

/**
 * 创意服务
 *
 * @author weny.cai
 * @date 2018/12/3 14:26
 **/
@AdvancedFeignClient
public interface RemoteResourceIdeaService {

    boolean add(ResourceIdeaDto dto) throws BizException;

    boolean update(ResourceIdeaDto dto) throws BizException;

    PageDto<ResourceIdeaDto> pageQuery(ResourceIdeaPageReq req);

    List<ResourceIdeaDto> queryListByResourceId(Long resourceId);

    Boolean sortIdea(IdeaSortReq req) throws BizException;

    ResourceIdeaDto getIdeaById(Long id);

    boolean changeSwitchStateById(Long id,Integer switchState);

    List<IdeaPictureDto> getPictureByIdeaId(Long ideaId);

    /**
     * 手动触发获取审核状态
     * @param ideaId
     */
    void manualObtianAuditStatus(Long ideaId);

    void deleteById(Long id) throws BizException;

    /**
     * 获取adx广告位id
      * @return
     */
    List<Long> selelctAdxSlotIds();

    /**
     * 根据switchStatus查询创意
     *
     * @param switchStatus switchStatus
     * @return list
     */
    List<ResourceIdeaDto> queryAllIdeaBySwitchStatus(Integer switchStatus);

    /**
     * 根据创意Id查询审核记录
     * @param ideaId
     * @return
     */
    List<ResourceIdeaThreeRsp> queryForResourceIdeaAuditList(Long ideaId);
}
