package cn.com.duiba.tuia.activity.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.activity.center.api.common.PageDto;
import cn.com.duiba.tuia.activity.center.api.dto.CreditsConsumeDto;
import cn.com.duiba.wolf.dubbo.DubboResult;
import io.swagger.models.auth.In;


/**
 * 媒体接口产品化相关
 */
@AdvancedFeignClient
public interface RemoteCreditsService {
    /**
     * 获取计划 分页
     * @param id
     * @param title
     * @param creator
     * @param offset
     * @param max
     * @return
     */
    DubboResult<PageDto<CreditsConsumeDto>> getCreditsConsumeList(Long id, String title, String creator,Integer offset, Integer max);

    /**
     * 删除计划
     * @param id
     * @return
     */
    DubboResult<Boolean> deleteBuoy(Long id);

    /**
     * 判断计划是否存在
     * @param id
     * @return
     */
    DubboResult<Integer> selectCountById(Long id);
}
