package cn.com.duiba.tuia.activity.center.api.dto.adx;

import cn.com.duiba.tuia.activity.center.api.constant.adx.AdxIdeaAuditStatus;
import cn.com.duiba.tuia.activity.center.api.constant.adx.IdeaStyleStandardEnum;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 创意
 *
 * @author weny.cai
 * @date 2018/12/3 14:27
 **/
public class ResourceIdeaDto implements Serializable {

    private Long id;

    private Long resourceId;

    private String ideaName;

    private Integer switchState;

    private Long slotId;

    private String ideaTitle;

    private String ideaDesc;

    private String buttonText;

    private String iconUrl;

    private String picUrl;

    private Integer directType;

    private Integer budgetType;

    private Double dayBudget;

    private Double ideaPrice;

    private Integer seqNum;

    private Integer iconH;

    private Integer iconW;

    private Integer picH;

    private Integer picW;

    private String resourceName;

    private String groupName;

    private Long groupId;

    private Integer adxType;

    private Integer sysState;

    private List<String> sysValue;

    private ResourceLocationDto resourceLocationDto;

    private List<IdeaPictureDto> ideaPictureDtos;

    /**
     * 规格样式
     * {@link IdeaStyleStandardEnum}
     */
    private Integer styleStandard;

    private Integer exposurePv;

    private Integer clickPv;

    private String price;

    private String clickRate;

    private String agvPrice;

    private String cpcPrice;

    /**
     * 出价类型类型 0-- 人工出价 1--算法出价
     */
    private Integer priceType;

    /**
     * 最低 ROI
     */
    private Double minRoi;

    /**
     * 最小创意出价：包含
     */
    private Double minPrice;

    /**
     * 最大创意出价：包含
     */
    private Double maxPrice;

    private Integer timesLimitFlag;

    private Integer timesLimitType;

    private Integer limitNum;

    /**
     * 审核状态 {@link AdxIdeaAuditStatus}
     */
    private Integer auditStatus;

    /**
     * 审核理由
     */
    private String auditReason;

    /**
     * 失效时间
     */
    private Date expireTime;

    /**
     * 创意审核状态
     */
    private List<ResourceIdeaAuditDto> resourceIdeaAuditDtoList;
    /**
     * 可投资源位列表
     */
    private List<ShortResourceLocationDto> enableResourceLocations;


    public List<ShortResourceLocationDto> getEnableResourceLocations() {
        return enableResourceLocations;
    }

    public void setEnableResourceLocations(List<ShortResourceLocationDto> enableResourceLocations) {
        this.enableResourceLocations = enableResourceLocations;
    }

    /** 投放地域（0：不限，1：自定义）默认0 */
    private Integer putAreaType;

    /** 区域码（多个以逗号拼接） */
    private String areaCode;

    /** 地域码集合 */
    private List<Long> areaCodeList;

    public List<ResourceIdeaAuditDto> getResourceIdeaAuditDtoList() {
        return resourceIdeaAuditDtoList;
    }

    public void setResourceIdeaAuditDtoList(List<ResourceIdeaAuditDto> resourceIdeaAuditDtoList) {
        this.resourceIdeaAuditDtoList = resourceIdeaAuditDtoList;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getResourceId() {
        return resourceId;
    }

    public void setResourceId(Long resourceId) {
        this.resourceId = resourceId;
    }

    public String getIdeaName() {
        return ideaName;
    }

    public void setIdeaName(String ideaName) {
        this.ideaName = ideaName;
    }

    public Integer getSwitchState() {
        return switchState;
    }

    public void setSwitchState(Integer switchState) {
        this.switchState = switchState;
    }

    public Long getSlotId() {
        return slotId;
    }

    public void setSlotId(Long slotId) {
        this.slotId = slotId;
    }

    public String getIdeaTitle() {
        return ideaTitle;
    }

    public void setIdeaTitle(String ideaTitle) {
        this.ideaTitle = ideaTitle;
    }

    public String getIdeaDesc() {
        return ideaDesc;
    }

    public void setIdeaDesc(String ideaDesc) {
        this.ideaDesc = ideaDesc;
    }

    public String getButtonText() {
        return buttonText;
    }

    public void setButtonText(String buttonText) {
        this.buttonText = buttonText;
    }

    public String getIconUrl() {
        return iconUrl;
    }

    public void setIconUrl(String iconUrl) {
        this.iconUrl = iconUrl;
    }

    public String getPicUrl() {
        return picUrl;
    }

    public void setPicUrl(String picUrl) {
        this.picUrl = picUrl;
    }

    public Integer getDirectType() {
        return directType;
    }

    public void setDirectType(Integer directType) {
        this.directType = directType;
    }

    public Integer getBudgetType() {
        return budgetType;
    }

    public void setBudgetType(Integer budgetType) {
        this.budgetType = budgetType;
    }

    public Double getDayBudget() {
        return dayBudget;
    }

    public void setDayBudget(Double dayBudget) {
        this.dayBudget = dayBudget;
    }

    public Double getIdeaPrice() {
        return ideaPrice;
    }

    public void setIdeaPrice(Double ideaPrice) {
        this.ideaPrice = ideaPrice;
    }

    public Integer getSeqNum() {
        return seqNum;
    }

    public void setSeqNum(Integer seqNum) {
        this.seqNum = seqNum;
    }

    public String getResourceName() {
        return resourceName;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    public String getGroupName() {
        return groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public ResourceLocationDto getResourceLocationDto() {
        return resourceLocationDto;
    }

    public void setResourceLocationDto(ResourceLocationDto resourceLocationDto) {
        this.resourceLocationDto = resourceLocationDto;
    }

    public List<IdeaPictureDto> getIdeaPictureDtos() {
        return ideaPictureDtos;
    }

    public void setIdeaPictureDtos(List<IdeaPictureDto> ideaPictureDtos) {
        this.ideaPictureDtos = ideaPictureDtos;
    }

    public Integer getIconH() {
        return iconH;
    }

    public void setIconH(Integer iconH) {
        this.iconH = iconH;
    }

    public Integer getIconW() {
        return iconW;
    }

    public void setIconW(Integer iconW) {
        this.iconW = iconW;
    }

    public Integer getPicH() {
        return picH;
    }

    public void setPicH(Integer picH) {
        this.picH = picH;
    }

    public Integer getPicW() {
        return picW;
    }

    public void setPicW(Integer picW) {
        this.picW = picW;
    }

    public Integer getExposurePv() {
        return exposurePv;
    }

    public void setExposurePv(Integer exposurePv) {
        this.exposurePv = exposurePv;
    }

    public Integer getClickPv() {
        return clickPv;
    }

    public void setClickPv(Integer clickPv) {
        this.clickPv = clickPv;
    }

    public String getPrice() {
        return price;
    }

    public void setPrice(String price) {
        this.price = price;
    }

    public String getClickRate() {
        return clickRate;
    }

    public void setClickRate(String clickRate) {
        this.clickRate = clickRate;
    }

    public Long getGroupId() {
        return groupId;
    }

    public void setGroupId(Long groupId) {
        this.groupId = groupId;
    }

    public Integer getAdxType() {
        return adxType;
    }

    public void setAdxType(Integer adxType) {
        this.adxType = adxType;
    }

    public String getAgvPrice() {
        return agvPrice;
    }

    public void setAgvPrice(String agvPrice) {
        this.agvPrice = agvPrice;
    }

    public String getCpcPrice() {
        return cpcPrice;
    }

    public void setCpcPrice(String cpcPrice) {
        this.cpcPrice = cpcPrice;
    }

    public Integer getSysState() {
        return sysState;
    }

    public void setSysState(Integer sysState) {
        this.sysState = sysState;
    }

    public List<String> getSysValue() {
        return sysValue;
    }

    public void setSysValue(List<String> sysValue) {
        this.sysValue = sysValue;
    }

    public Integer getPriceType() {
        return priceType;
    }

    public void setPriceType(Integer priceType) {
        this.priceType = priceType;
    }

    public Double getMinRoi() {
        return minRoi;
    }

    public void setMinRoi(Double minRoi) {
        this.minRoi = minRoi;
    }

    public Double getMinPrice() {
        return minPrice;
    }

    public void setMinPrice(Double minPrice) {
        this.minPrice = minPrice;
    }

    public Double getMaxPrice() {
        return maxPrice;
    }

    public void setMaxPrice(Double maxPrice) {
        this.maxPrice = maxPrice;
    }

    public Integer getStyleStandard() {
        return styleStandard;
    }

    public void setStyleStandard(Integer styleStandard) {
        this.styleStandard = styleStandard;
    }

    public Integer getAuditStatus() {
        return auditStatus;
    }

    public void setAuditStatus(Integer auditStatus) {
        this.auditStatus = auditStatus;
    }

    public String getAuditReason() {
        return auditReason;
    }

    public void setAuditReason(String auditReason) {
        this.auditReason = auditReason;
    }

    public Date getExpireTime() {
        return expireTime;
    }

    public void setExpireTime(Date expireTime) {
        this.expireTime = expireTime;
    }

    public Integer getTimesLimitFlag() {
        return timesLimitFlag;
    }

    public void setTimesLimitFlag(Integer timesLimitFlag) {
        this.timesLimitFlag = timesLimitFlag;
    }

    public Integer getTimesLimitType() {
        return timesLimitType;
    }

    public void setTimesLimitType(Integer timesLimitType) {
        this.timesLimitType = timesLimitType;
    }

    public Integer getLimitNum() {
        return limitNum;
    }

    public void setLimitNum(Integer limitNum) {
        this.limitNum = limitNum;
    }

    public Integer getPutAreaType() {
        return putAreaType;
    }

    public void setPutAreaType(Integer putAreaType) {
        this.putAreaType = putAreaType;
    }

    public String getAreaCode() {
        return areaCode;
    }

    public void setAreaCode(String areaCode) {
        this.areaCode = areaCode;
    }

    public List<Long> getAreaCodeList() {
        return areaCodeList;
    }

    public void setAreaCodeList(List<Long> areaCodeList) {
        this.areaCodeList = areaCodeList;
    }
}
