package cn.com.duiba.tuia.activity.center.api.remoteservice.story;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.activity.center.api.dto.story.StoryUserReq;
import cn.com.duiba.tuia.activity.center.api.dto.story.lucky.StoryLuckyDrawInfoDto;
import cn.com.duiba.tuia.activity.center.api.dto.story.lucky.StoryLuckyDrawPrizeDto;
import cn.com.duiba.tuia.activity.center.api.dto.story.lucky.req.StoryLuckyDrawConfigUpdateReq;

/**
 * [深度互动故事完整性] 用户抽奖Remote接口
 * RemoteStoryLuckyDrawService
 *
 * @author huangruodan
 * @date 2019/6/4
 */

@AdvancedFeignClient
public interface RemoteStoryLuckyDrawService {

    /**
     * 媒体抽奖页面初始化(中奖列表,抽奖配置)
     * @param userReq 用户信息
     * @return 抽奖信息(中奖列表,抽奖配置)
     * @throws BizException 业务异常
     */
    StoryLuckyDrawInfoDto luckyDrawInit(StoryUserReq userReq) throws BizException;

    /**
     * 抽奖订单回调
     * @param tawOrderId 推啊订单id
     * @param recordId 抽奖记录id
     * @return 是否成功
     * @throws BizException 业务异常
     */
    Boolean luckyDrawOrderCallBack(String tawOrderId, Long recordId) throws BizException;

    /**
     * 插入或更新媒体抽奖配置
     * @param updateLuckyDrawConfig 每次抽奖消耗金币数
     * @return 是否成功
     * @throws BizException 业务异常
     */
    Boolean updateLuckyDrawConfig(StoryLuckyDrawConfigUpdateReq updateLuckyDrawConfig) throws BizException;


    /**
     * 用户抽奖
     * @param userReq 用户信息
     * @return 抽奖结果
     * @throws BizException 业务异常
     */
    StoryLuckyDrawPrizeDto userLuckyDraw(StoryUserReq userReq) throws BizException;
}
