package cn.com.duiba.tuia.activity.center.api.constant.adx;

import java.util.Objects;
import java.util.stream.Stream;

/**
 * adx平台类型
 *
 * @author weny.cai
 * @date 2019/1/3 15:46
 **/
public enum AdxTypeEnum {

    LIEBAO(1, "猎豹",false,1),
    SOUGOU(2, "搜狗",false,1),
    MOJI(3, "墨迹天气",false,1),
    BAOFENG(4, "暴风影音",false, 2),
    BAIDU(5, "百度视频",true,2),
    XIAOMI(6, "小米",false,2),
    ZHANG_YUE(7,"掌阅",true,2),
    NAVIGATION(8, "2345", true, 3);

    private Integer type;

    private String name;

    private Boolean needAudit;
    /**
     * 广告类型存储方式 1-posId 2-spec_code 3-其他
     */
    private Integer storeType;

    AdxTypeEnum(Integer type, String name, Boolean needAudit, Integer storeType) {
        this.type = type;
        this.name = name;
        this.needAudit = needAudit;
        this.storeType = storeType;
    }

    public Integer getStoreType() {
        return storeType;
    }

    public void setStoreType(Integer storeType) {
        this.storeType = storeType;
    }

    public Integer getType() {
        return type;
    }

    public String getName() {
        return name;
    }

    public Boolean getNeedAudit() {
        return needAudit;
    }

    public boolean sameAdxType(Integer type){
        return !Objects.isNull(type) && Objects.equals(this.type,type);
    }

    public static AdxTypeEnum getByType(Integer type) {
        return Objects.isNull(type)
                ? null
                : Stream.of(AdxTypeEnum.values())
                        .filter(item -> Objects.equals(item.getType(), type))
                        .findFirst().orElse(null);
    }

    public static Boolean needAudit(Integer adxType){
        for(AdxTypeEnum adxTypeEnum : AdxTypeEnum.values()){
            if(adxType.equals(adxTypeEnum.getType())){
                return adxTypeEnum.getNeedAudit();
            }
        }
        return false;
    }

    public static  Boolean contains(Integer adxType){
        for(AdxTypeEnum adxTypeEnum : AdxTypeEnum.values()){
            if(adxType == adxTypeEnum.getType()){
                return true;
            }
        }
        return false;
    }
}
