package cn.com.duiba.tuia.activity.center.api.remoteservice.adx;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.activity.center.api.bean.dto.SlotDTO;
import cn.com.duiba.tuia.activity.center.api.common.PageDto;
import cn.com.duiba.tuia.activity.center.api.dto.adx.ResourceLocationDto;
import cn.com.duiba.tuia.activity.center.api.dto.adx.ResourcePicSpecificationDto;
import cn.com.duiba.tuia.activity.center.api.dto.req.ResourceLocationPageReq;

import java.util.List;

/**
 * 资源位
 *
 * @author weny.cai
 * @date 2018/11/30 10:50
 **/
@AdvancedFeignClient
public interface RemoteResourceLocationService {

    boolean add(ResourceLocationDto resourceLocationDto) throws BizException;

    boolean judgeSameSlot(Long groupId, List<String> posIds);

    boolean update(ResourceLocationDto resourceLocationDto) throws BizException;

    ResourceLocationDto getResourceLocationDto(Long id);

    PageDto<ResourceLocationDto> pageQuery(ResourceLocationPageReq req);

    List<ResourceLocationDto> getAll();

    boolean changeSwitchStateById(Long id,Integer switchState);

    List<ResourcePicSpecificationDto> getResourceSpecById(Long resourceId);

    boolean isExistPic(Long specId) throws BizException;

    boolean savePutType(Long sourceId,Integer putType);

    ResourceLocationDto getResourceByTagId(String tagId);

    Long getGroupIdByResourceId(Long resourceId);

    void deleteById(Long id) throws BizException;

    /**
     * 根据资源位Id查询关联第三方的广告位标识
     * @param resourceLocationId 资源位Id
     * @return 返回集合
     */
    List<String> queryPosIdsById(Long resourceLocationId);

    /**
     *  根据第三方广告位Ids查询
      * @param impIds
     *  @return 返回推啊广告位Ids
     */
    List<String> getResourceIdsByImpIds(List<String> impIds);

    /**
     * 根据adxType查询广告位
     * @param adxType
     * @return 广告位集合
     */
    List<SlotDTO> queryAllSlot(Integer adxType);

}
