package cn.com.duiba.tuia.activity.center.api.constant.adx;

import java.util.Objects;
import java.util.stream.Stream;

/**
 * adx创意审核状态枚举
 * @Author chensong
 * @Create 2019-03-05
 */
public enum AdxIdeaAuditStatus {

    TO_AUDIT(1, "TO_AUDIT", "待审核"),

    AUDIT_PASSED(2, "AUDIT_PASSED", "审核通过"),

    AUDIT_REFUSED(3, "AUDIT_REFUSED", "审核拒绝");

    /** 数字 */
    int num;

    /** 代码 */
    String code;

    /** 描述 */
    String desc;

    public int getNum() {
        return num;
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    private AdxIdeaAuditStatus(int num, String code, String desc) {
        this.num = num;
        this.code = code;
        this.desc = desc;
    }

    public static AdxIdeaAuditStatus getByNum(Integer num) {
        return Objects.isNull(num)
                ? null
                : Stream.of(AdxIdeaAuditStatus.values())
                        .filter(item -> Objects.equals(item.getNum(), num))
                        .findFirst().orElse(null);
    }

}
