package cn.com.duiba.tuia.activity.center.api.remoteservice.commercial.mission;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.activity.center.api.dto.commercial.mission.config.*;

import java.util.List;

/**
 * [深度互动]任务配置Remote接口
 *
 * @author zhangbaiqiang
 * @date 2019-04-17
 */
@AdvancedFeignClient
public interface RemoteMissionConfigService {

    /**
     * 获取任务列表
     */
    List<RspMissionDto> getMissionList(ReqMissionDto req);

    /**
     * 根据id获取任务配置
     */
    RspMissionConfigDto getMissionConfigById(ReqMissionDto req);

    /**
     * 新增任务
     */
    void addMissionConfig(ReqMissionConfigDto req);

    /**
     * 更新任务
     */
    void updateMissionConfig(ReqMissionConfigDto req);

    /**
     * 获取任务条件列表
     */
    List<RspMissionConditionDto> getMissionConditionList(ReqMissionDto req);


    /**
     * 获取任务奖励列表
     */
    List<RspMissionPrizeDto> getMissionPrizeList(ReqMissionDto req);
}
