package cn.com.duiba.tuia.activity.center.api.remoteservice.story;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.activity.center.api.dto.story.StoryAppDto;
import cn.com.duiba.tuia.activity.center.api.dto.story.config.ReqAppDto;

/**
 *
 * RemoteStoryAppService
 *
 * @author huangruodan
 * @date 2019/5/29
 */

@AdvancedFeignClient
public interface RemoteStoryAppService {

    /**
     * 获取媒体信息
     *
     * @param appId 媒体id
     * @return 媒体信息
     */
    StoryAppDto getByAppId(Long appId) throws BizException;

    /**
     * 校验媒体是否已经配置
     */
    Boolean isAppExist(ReqAppDto req);

    /**
     * 获取媒体的代币名称
     *
     * @param appId 媒体id
     * @return 代币名称
     */
    String getCoinName(Long appId);
}
