package cn.com.duiba.tuia.activity.center.api.remoteservice.story;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.activity.center.api.dto.story.StoryUserReq;
import cn.com.duiba.tuia.activity.center.api.dto.story.user.StoryUserDto;

/**
 * RemoteStoryUserService
 *
 * @author huangruodan
 * @date 2019/5/29
 */

@AdvancedFeignClient
public interface RemoteStoryUserService {

    /**
     * 查询用户信息，若没有则新建
     * @param storyUserReq 用户信息
     * @return 基础用户信息
     * @throws BizException 用户信息获取失败
     */
    StoryUserDto queryOrCreateStoryUser(StoryUserReq storyUserReq) throws BizException;

    /**
     * 更新用户信息
     * @param storyUser 用户
     * @return 是否成功
     * @throws BizException 业务异常
     */
    Boolean updateStoryUser(StoryUserDto storyUser) throws BizException;

}
