package cn.com.duiba.tuia.activity.center.api.remoteservice.story;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.activity.center.api.constant.commercial.plant.PlantConfigDto;
import cn.com.duiba.tuia.activity.center.api.dto.commercial.plant.PlantDto;
import cn.com.duiba.tuia.activity.center.api.dto.story.StoryUserReq;
import cn.com.duiba.tuia.activity.center.api.dto.story.lucky.StoryLuckyDrawInfoDto;
import cn.com.duiba.tuia.activity.center.api.dto.story.lucky.StoryLuckyDrawPrizeDto;
import cn.com.duiba.tuia.activity.center.api.dto.story.spike.StorySpikeResultDto;
import cn.com.duiba.tuia.activity.center.api.dto.story.spike.StoryUserSpikeInitInfoDto;
import cn.com.duiba.tuia.activity.center.api.dto.story.spike.StoryUserSpikePrizeDto;
import cn.com.duiba.tuia.activity.center.api.dto.story.spike.req.StoryUserSpikeCallBackReq;

import java.util.List;

/**
 * [商业化活动]种红包Remote接口
 *
 * @author zhangbaiqiang
 * @date 2019-03-08
 */
@AdvancedFeignClient
public interface RemoteStoryPlantService {

    /**
     * 签到
     *
     * @param req 用户参数
     * @return 种红包所有信息
     * @throws BizException
     */
    PlantDto sign(StoryUserReq req) throws BizException;

    /**
     * 种红包
     *
     * @param req 用户参数
     * @param landId 土地编号
     * @param seedType 种子类型
     * @return 用户信息、土地信息、种子仓库
     * @throws BizException
     */
    PlantDto plant(StoryUserReq req, Integer landId, Integer seedType) throws BizException;

    /**
     * 采摘红包
     *
     * @param req 用户参数
     * @param seedId 种子编号
     * @return 用户信息，奖励信息
     * @throws BizException
     */
    PlantDto pick(StoryUserReq req, Long seedId) throws BizException;

    /**
     * 领取任务奖励
     *
     * @param req 用户参数
     * @param missionId 任务编号
     * @return 用户信息，奖励信息
     */
    PlantDto finishMission(StoryUserReq req, String missionId) throws BizException;

    /**
     * 领取场景任务奖励
     *
     * @param req 用户参数
     * @param missionId 任务编号
     * @return 用户信息，奖励信息
     */
    PlantDto finishSceneMission(StoryUserReq req, String missionId) throws BizException;

    /**
     * 获取种红包奖励配置
     *
     * @return 种红包奖励配置
     */
    PlantConfigDto queryPrizeConfig() throws BizException;

    /**
     * 更新奖励配置参数(慎用)
     *
     * @param configDto 奖励配置对象
     * @return 是否更新成功
     */
    boolean updatePlantConfig(PlantConfigDto configDto);

    /**
     * [测试用接口]清除缓存
     *
     * @param deviceId 设备id
     * @param appId 媒体id
     * @param date 签到日期
     */
    Boolean resetForTest(String deviceId, Long appId, String date);

    /**
     * 获取用户秒杀初始页面信息
     * @param req 请求参数
     * @return 秒杀信息
     * @throws BizException 业务异常
     */
    StoryUserSpikeInitInfoDto spikeInfoInit(StoryUserReq req) throws BizException;

    /**
     * 用户秒杀
     * @param req 请求参数(媒体信息，设备信息)
     * @param itemId 秒杀itemId
     * @return 是否扣除库存成功
     * @throws BizException 业务异常
     */
    StorySpikeResultDto userSpike(StoryUserReq req, Long itemId) throws BizException;

    /**
     * 秒杀中奖和已经抽奖中现金红包的用户列表
     * @param req 请求参数(媒体信息，设备信息)
     * @return 中奖名单
     * @throws BizException 业务异常
     */
    List<StoryUserSpikePrizeDto> getPrizeList(StoryUserReq req) throws BizException;

    /**
     * 秒杀抽奖订单回调
     * @param req 参数(用户数据,订单id,秒杀记录id)
     * @throws BizException 业务异常
     * @return 是否成功
     */
    Boolean spikeOrderCallBack(StoryUserSpikeCallBackReq req) throws BizException;

    /**
     * 用户抽奖
     * @param userReq 用户信息
     * @return 抽奖结果
     * @throws BizException 业务异常
     */
    StoryLuckyDrawPrizeDto userLuckyDraw(StoryUserReq userReq) throws BizException;


    /**
     * 媒体抽奖页面初始化(中奖列表,抽奖配置)
     * @param userReq 用户信息
     * @return 抽奖信息(中奖列表,抽奖配置)
     * @throws BizException 业务异常
     */
    StoryLuckyDrawInfoDto luckyDrawInit(StoryUserReq userReq) throws BizException;

    /**
     * 抽奖订单回调
     * @param tawOrderId 推啊订单id
     * @param recordId 抽奖记录id
     * @return 是否成功
     * @throws BizException 业务异常
     */
    Boolean luckyDrawOrderCallBack(String tawOrderId, Long recordId) throws BizException;

    /**
     * 插入或更新媒体抽奖配置
     * @param appId 媒体id
     * @param costCoin 每次抽奖消耗金币数
     * @return 是否成功
     * @throws BizException 业务异常
     */
    Boolean updateLuckyDrawConfig(Long appId, Integer costCoin) throws BizException;

}
