/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.activity.center.api.constant.story.tree;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Objects;

public enum TreeType {
    NORMAL(1, "\u666e\u901a", 1),
    TWO(2, "TWO", 2);

    private Integer type;
    private String desc;
    private Integer sort;

    private TreeType(Integer type, String desc, Integer sort) {
        this.type = type;
        this.desc = desc;
        this.sort = sort;
    }

    public static TreeType valueOf(Integer type) {
        for (TreeType typeEnum : TreeType.values()) {
            if (!Objects.equals(typeEnum.getType(), type)) continue;
            return typeEnum;
        }
        return null;
    }

    public static TreeType getNextTree(Integer type) {
        if (type == null) {
            return NORMAL;
        }
        ArrayList treeTypeList = Lists.newArrayList((Object[])TreeType.values());
        treeTypeList.sort(Comparator.comparingInt(TreeType::getSort));
        int index = -1;
        for (TreeType tree : treeTypeList) {
            ++index;
            if (!type.equals(tree.getType())) continue;
            break;
        }
        if (index >= treeTypeList.size() - 1) {
            return null;
        }
        return (TreeType)((Object)treeTypeList.get(index + 1));
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public Integer getSort() {
        return this.sort;
    }

    public void setSort(Integer sort) {
        this.sort = sort;
    }

    public Integer getType() {
        return this.type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getDesc() {
        return this.desc;
    }
}

